/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.ciba;

import io.jans.as.model.common.BackchannelTokenDeliveryMode;
import io.jans.as.model.common.GrantType;
import io.jans.as.model.common.SubjectType;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.model.crypto.signature.AsymmetricSignatureAlgorithm;
import io.jans.as.model.util.Util;
import jakarta.ejb.Stateless;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.core.Response;
import java.util.List;
import org.apache.logging.log4j.util.Strings;
import org.json.JSONArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stateless
@Named
public class CIBARegisterParamsValidatorService {
    private static final Logger log = LoggerFactory.getLogger(CIBARegisterParamsValidatorService.class);
    @Inject
    private AppConfiguration appConfiguration;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean validateParams(BackchannelTokenDeliveryMode backchannelTokenDeliveryMode, String backchannelClientNotificationEndpoint, AsymmetricSignatureAlgorithm backchannelAuthenticationRequestSigningAlg, List<GrantType> grantTypes, SubjectType subjectType, String sectorIdentifierUri, String jwks, String jwksUri) {
        try {
            if (backchannelTokenDeliveryMode == null && Strings.isBlank((String)backchannelClientNotificationEndpoint) && backchannelAuthenticationRequestSigningAlg == null) {
                return true;
            }
            if (backchannelTokenDeliveryMode == null) return false;
            if (!this.appConfiguration.getBackchannelTokenDeliveryModesSupported().contains(backchannelTokenDeliveryMode.getValue())) {
                return false;
            }
            if ((backchannelTokenDeliveryMode == BackchannelTokenDeliveryMode.PING || backchannelTokenDeliveryMode == BackchannelTokenDeliveryMode.PUSH) && Strings.isBlank((String)backchannelClientNotificationEndpoint)) {
                return false;
            }
            if (backchannelTokenDeliveryMode == BackchannelTokenDeliveryMode.PING || backchannelTokenDeliveryMode == BackchannelTokenDeliveryMode.POLL) {
                if (!this.appConfiguration.getGrantTypesSupported().contains(GrantType.CIBA)) return false;
                if (!grantTypes.contains(GrantType.CIBA)) {
                    return false;
                }
            }
            if (subjectType == null) return true;
            if (subjectType != SubjectType.PAIRWISE) return true;
            if ((backchannelTokenDeliveryMode == BackchannelTokenDeliveryMode.PING || backchannelTokenDeliveryMode == BackchannelTokenDeliveryMode.POLL) && Strings.isBlank((String)jwks) && Strings.isBlank((String)jwksUri)) {
                return false;
            }
            if (!Strings.isNotBlank((String)sectorIdentifierUri)) return true;
            String entity = null;
            try (Client clientRequest = ClientBuilder.newClient();){
                Response clientResponse = clientRequest.target(sectorIdentifierUri).request().buildGet().invoke();
                int status = clientResponse.getStatus();
                if (status != 200) {
                    boolean bl = false;
                    return bl;
                }
                entity = (String)clientResponse.readEntity(String.class);
            }
            JSONArray sectorIdentifierJsonArray = new JSONArray(entity);
            if (backchannelTokenDeliveryMode != BackchannelTokenDeliveryMode.PING && backchannelTokenDeliveryMode != BackchannelTokenDeliveryMode.POLL) {
                if (backchannelTokenDeliveryMode != BackchannelTokenDeliveryMode.PUSH) return true;
                if (Util.asList((JSONArray)sectorIdentifierJsonArray).contains(backchannelClientNotificationEndpoint)) return true;
                return false;
            }
            if (Strings.isBlank((String)jwksUri)) return true;
            if (Util.asList((JSONArray)sectorIdentifierJsonArray).contains(jwksUri)) return true;
            return false;
        }
        catch (Exception e) {
            log.trace(e.getMessage(), (Throwable)e);
            return false;
        }
    }
}

