/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.jans.ws.rs;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.jans.as.common.service.AttributeService;
import io.jans.as.model.common.FeatureFlagType;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.model.error.ErrorResponseFactory;
import io.jans.as.model.error.IErrorType;
import io.jans.as.model.gluu.GluuConfiguration;
import io.jans.as.model.gluu.GluuErrorResponseType;
import io.jans.as.persistence.model.Scope;
import io.jans.as.server.service.ScopeService;
import io.jans.as.server.service.external.ExternalAuthenticationService;
import io.jans.as.server.util.ServerUtil;
import io.jans.model.JansAttribute;
import io.jans.model.custom.script.conf.CustomScriptConfiguration;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

@Path(value="/.well-known/jans-configuration")
public class JansConfigurationWS {
    @Inject
    private Logger log;
    @Inject
    private ScopeService scopeService;
    @Inject
    private AttributeService attributeService;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private ExternalAuthenticationService externalAuthenticationService;

    @GET
    @Produces(value={"application/json"})
    public Response getConfiguration() {
        this.errorResponseFactory.validateFeatureEnabled(FeatureFlagType.JANS_CONFIGURATION);
        try {
            GluuConfiguration conf = new GluuConfiguration();
            conf.setIdGenerationEndpoint(this.appConfiguration.getIdGenerationEndpoint());
            conf.setIntrospectionEndpoint(this.appConfiguration.getIntrospectionEndpoint());
            conf.setAuthLevelMapping(this.createAuthLevelMapping());
            conf.setScopeToClaimsMapping(this.createScopeToClaimsMapping());
            String entity = ServerUtil.asPrettyJson(conf);
            this.log.trace("Gluu configuration: {}", (Object)entity);
            return Response.ok((Object)entity).build();
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.errorResponseFactory.getErrorResponse((IErrorType)GluuErrorResponseType.SERVER_ERROR)).build());
        }
    }

    public Map<Integer, Set<String>> createAuthLevelMapping() {
        HashMap map = Maps.newHashMap();
        try {
            for (CustomScriptConfiguration script : this.externalAuthenticationService.getCustomScriptConfigurationsMap()) {
                String acr = script.getName();
                int level = script.getLevel();
                Set acrs = (Set)map.get(level);
                if (acrs == null) {
                    acrs = Sets.newHashSet();
                    map.put(level, acrs);
                }
                acrs.add(acr);
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return map;
    }

    private Map<String, Set<String>> createScopeToClaimsMapping() {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        try {
            for (Scope scope : this.scopeService.getAllScopesList()) {
                HashSet<String> claimsList = new HashSet<String>();
                result.put(scope.getId(), claimsList);
                List claimIdList = scope.getClaims();
                if (claimIdList == null || claimIdList.isEmpty()) continue;
                for (String claimDn : claimIdList) {
                    JansAttribute attribute = this.attributeService.getAttributeByDn(claimDn);
                    String claimName = attribute.getClaimName();
                    if (!StringUtils.isNotBlank((CharSequence)claimName)) continue;
                    claimsList.add(claimName);
                }
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }
}

