/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.jwk.ws.rs;

import io.jans.as.common.model.common.ArchivedJwk;
import io.jans.as.model.authorize.AuthorizeErrorResponseType;
import io.jans.as.model.config.StaticConfiguration;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.model.error.ErrorResponseFactory;
import io.jans.as.model.error.IErrorType;
import io.jans.as.model.jwk.JSONWebKey;
import io.jans.as.model.jwk.JSONWebKeySet;
import io.jans.orm.PersistenceEntryManager;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;

@Named
public class ArchivedJwksService {
    public static final int SECONDS_IN_ONE_YEAR = 31536000;
    @Inject
    private Logger log;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private PersistenceEntryManager persistenceEntryManager;
    @Inject
    private StaticConfiguration staticConfiguration;
    @Inject
    private ErrorResponseFactory errorResponseFactory;

    public String buildDn(String id) {
        return String.format("jansId=%s,%s", id, this.staticConfiguration.getBaseDn().getArchivedJwks());
    }

    public ArchivedJwk getArchivedJwkByDn(String dn) {
        try {
            return (ArchivedJwk)this.persistenceEntryManager.find(ArchivedJwk.class, (Object)dn);
        }
        catch (Exception e) {
            this.log.trace(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public Response requestArchivedKid(String kid) {
        this.log.debug("Requesting archived kid {} ...", (Object)kid);
        ArchivedJwk archivedJwk = this.getArchivedJwk(kid);
        if (archivedJwk == null) {
            this.log.trace("Unable to find archived jwk by kid {}", (Object)kid);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)this.errorResponseFactory.errorAsJson((IErrorType)AuthorizeErrorResponseType.INVALID_REQUEST, "")).build());
        }
        String entity = JSONWebKeySet.toPrettyString((JSONObject)archivedJwk.getData());
        if (this.log.isTraceEnabled()) {
            this.log.trace("Returned archived jwk, kid: {}, entity: {}", (Object)kid, (Object)entity);
        }
        return Response.ok().type(MediaType.APPLICATION_JSON_TYPE).entity((Object)entity).build();
    }

    public ArchivedJwk getArchivedJwk(String kid) {
        if (StringUtils.isNotBlank((CharSequence)kid)) {
            ArchivedJwk result = this.getArchivedJwkByDn(this.buildDn(kid));
            this.log.debug("Found {} entries for ArchivedJwk id = {}", (Object)(result != null ? 1 : 0), (Object)kid);
            return result;
        }
        return null;
    }

    public void persist(ArchivedJwk entity) {
        this.persistenceEntryManager.persist((Object)entity);
    }

    public void merge(ArchivedJwk entity) {
        this.persistenceEntryManager.merge((Object)entity);
    }

    public void archiveJwk(JSONObject keyAsJson) {
        if (keyAsJson == null) {
            this.log.trace("JWK is null, skip archiving.");
            return;
        }
        try {
            JSONWebKey jwk = JSONWebKey.fromJSONObject((JSONObject)keyAsJson);
            String kid = jwk.getKid();
            ArchivedJwk existing = this.getArchivedJwk(kid);
            if (existing != null) {
                this.log.debug("JWK {} already archived.", (Object)kid);
                return;
            }
            this.log.debug("Trying to archive jwk {} ...", (Object)kid);
            ArchivedJwk archivedJwk = new ArchivedJwk();
            archivedJwk.setDn(this.buildDn(kid));
            archivedJwk.setId(kid);
            archivedJwk.setData(keyAsJson);
            archivedJwk.setCreationDate(new Date());
            archivedJwk.setDeletable(Boolean.valueOf(true));
            archivedJwk.setExpirationDate(this.getExpirationDate());
            archivedJwk.setTtl(this.getLifetimeInSeconds());
            this.persist(archivedJwk);
            this.log.debug("Archived jwk {} successfully.", (Object)kid);
        }
        catch (Exception e) {
            this.log.error("Failed to archive jwk: {}", (Object)keyAsJson);
        }
    }

    public int getLifetimeInSeconds() {
        int lifetimeFromConfig = this.appConfiguration.getArchivedJwkLifetimeInSeconds();
        if (lifetimeFromConfig > 0) {
            return lifetimeFromConfig;
        }
        return 31536000;
    }

    private Date getExpirationDate() {
        int lifetimeInSeconds = this.getLifetimeInSeconds();
        Calendar calendar = Calendar.getInstance();
        calendar.add(13, lifetimeInSeconds);
        return calendar.getTime();
    }

    public Map<String, JSONObject> findRemovedKeys(JSONObject existingJwks, JSONObject newJwks) {
        Map<String, JSONObject> existingMap = ArchivedJwksService.createKidToKeyMap(existingJwks);
        Map<String, JSONObject> newMap = ArchivedJwksService.createKidToKeyMap(newJwks);
        for (String kid : newMap.keySet()) {
            existingMap.remove(kid);
        }
        return existingMap;
    }

    public void archiveRemovedKeys(JSONObject existingJwks, JSONObject newJwks) {
        Map<String, JSONObject> removedKeys = this.findRemovedKeys(existingJwks, newJwks);
        for (Map.Entry<String, JSONObject> entry : removedKeys.entrySet()) {
            if (entry.getValue() == null) continue;
            this.archiveJwk(entry.getValue());
        }
    }

    public static Map<String, JSONObject> createKidToKeyMap(JSONObject jwks) {
        HashMap<String, JSONObject> map = new HashMap<String, JSONObject>();
        JSONArray keys = jwks.getJSONArray("keys");
        for (int i = 0; i < keys.length(); ++i) {
            JSONObject key = keys.getJSONObject(i);
            String kid = key.optString("kid");
            map.put(kid, key);
        }
        return map;
    }
}

