/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.model.common;

import io.jans.as.model.authzdetails.AuthzDetails;
import io.jans.as.model.common.GrantType;
import io.jans.as.server.model.common.AuthorizationGrant;
import io.jans.as.server.model.common.AuthorizationGrantType;
import io.jans.as.server.model.common.CacheGrant;
import io.jans.as.server.model.common.CibaRequestCacheControl;
import io.jans.service.CacheService;
import jakarta.inject.Inject;

public class CIBAGrant
extends AuthorizationGrant {
    private String authReqId;
    private boolean tokensDelivered;
    @Inject
    private CacheService cacheService;

    @Override
    public GrantType getGrantType() {
        return GrantType.CIBA;
    }

    public void init(CibaRequestCacheControl cibaRequest) {
        super.init(cibaRequest.getUser(), AuthorizationGrantType.CIBA, cibaRequest.getClient(), null);
        this.setAuthReqId(cibaRequest.getAuthReqId());
        this.setAcrValues(cibaRequest.getAcrValues());
        this.setScopes(cibaRequest.getScopes());
        this.setAuthzDetails(AuthzDetails.ofSilently((String)cibaRequest.getAuthzDetails()));
        this.setIsCachedWithNoPersistence(true);
    }

    @Override
    public void save() {
        CacheGrant cachedGrant = new CacheGrant(this, this.appConfiguration);
        this.cacheService.put(cachedGrant.getExpiresIn(), cachedGrant.getAuthReqId(), (Object)cachedGrant);
    }

    public String getAuthReqId() {
        return this.authReqId;
    }

    public void setAuthReqId(String authReqId) {
        this.authReqId = authReqId;
    }

    public boolean isTokensDelivered() {
        return this.tokensDelivered;
    }

    public void setTokensDelivered(boolean tokensDelivered) {
        this.tokensDelivered = tokensDelivered;
    }
}

