/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.model.config;

import io.jans.as.common.model.event.CryptoProviderEvent;
import io.jans.as.model.config.BaseDnConfiguration;
import io.jans.as.model.config.Conf;
import io.jans.as.model.config.StaticConfiguration;
import io.jans.as.model.config.WebKeysConfiguration;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.model.configuration.Configuration;
import io.jans.as.model.crypto.AbstractCryptoProvider;
import io.jans.as.model.crypto.CryptoProviderFactory;
import io.jans.as.model.error.ErrorMessages;
import io.jans.as.model.error.ErrorResponseFactory;
import io.jans.as.model.jwk.JSONWebKey;
import io.jans.as.model.jwk.JSONWebKeySet;
import io.jans.as.model.util.JwtUtil;
import io.jans.as.server.util.ServerUtil;
import io.jans.exception.ConfigurationException;
import io.jans.orm.PersistenceEntryManager;
import io.jans.orm.exception.BasePersistenceException;
import io.jans.orm.model.PersistenceConfiguration;
import io.jans.orm.service.PersistanceFactoryService;
import io.jans.service.ApplicationConfigurationFactory;
import io.jans.service.cdi.async.Asynchronous;
import io.jans.service.cdi.event.BaseConfigurationReload;
import io.jans.service.cdi.event.ConfigurationEvent;
import io.jans.service.cdi.event.ConfigurationUpdate;
import io.jans.service.cdi.event.LdapConfigurationReload;
import io.jans.service.cdi.event.Scheduled;
import io.jans.service.timer.event.TimerEvent;
import io.jans.service.timer.schedule.TimerSchedule;
import io.jans.util.StringHelper;
import io.jans.util.properties.FileConfiguration;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Event;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRegistration;
import java.io.File;
import java.lang.annotation.Annotation;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;
import org.slf4j.Logger;

@ApplicationScoped
public class ConfigurationFactory
extends ApplicationConfigurationFactory {
    @Inject
    private Logger log;
    @Inject
    private Event<TimerEvent> timerEvent;
    @Inject
    private Event<AppConfiguration> configurationUpdateEvent;
    @Inject
    private Event<AbstractCryptoProvider> cryptoProviderEvent;
    @Inject
    private Event<String> event;
    @Inject
    @Named(value="persistenceEntryManager")
    private Instance<PersistenceEntryManager> persistenceEntryManagerInstance;
    @Inject
    private PersistanceFactoryService persistanceFactoryService;
    @Inject
    private Instance<Configuration> configurationInstance;
    @Inject
    private Instance<AbstractCryptoProvider> abstractCryptoProviderInstance;
    public static final String PERSISTENCE_CONFIGURATION_RELOAD_EVENT_TYPE = "persistenceConfigurationReloadEvent";
    public static final String BASE_CONFIGURATION_RELOAD_EVENT_TYPE = "baseConfigurationReloadEvent";
    private static final int DEFAULT_INTERVAL = 30;
    private static final String BASE_DIR = System.getProperty("jans.base") != null ? System.getProperty("jans.base") : (System.getProperty("catalina.base") != null && System.getProperty("catalina.base.ignore") == null ? System.getProperty("catalina.base") : (System.getProperty("catalina.home") != null ? System.getProperty("catalina.home") : (System.getProperty("jboss.home.dir") != null ? System.getProperty("jboss.home.dir") : null)));
    private static final String DIR = BASE_DIR + File.separator + "conf" + File.separator;
    private static final String BASE_PROPERTIES_FILE = DIR + "jans.properties";
    private static final String APP_PROPERTIES_FILE = DIR + "jans-ldap.properties";
    private static final String CONFIG_FILE_NAME = "jans-config.json";
    private static final String ERRORS_FILE_NAME = "jans-errors.json";
    private static final String STATIC_CONF_FILE_NAME = "jans-static-conf.json";
    private static final String WEB_KEYS_FILE_NAME = "jans-web-keys.json";
    private String configFilePath;
    private String errorsFilePath;
    private String staticConfFilePath;
    private String webKeysFilePath;
    private String saltFilePath;
    private boolean loaded = false;
    private FileConfiguration baseConfiguration;
    private PersistenceConfiguration persistenceConfiguration;
    private AppConfiguration conf;
    private StaticConfiguration staticConf;
    private WebKeysConfiguration jwks;
    private ErrorResponseFactory errorResponseFactory;
    private String cryptoConfigurationSalt;
    private String contextPath;
    private String facesMapping;
    private AtomicBoolean isActive;
    private long baseConfigurationFileLastModifiedTime;
    private long loadedRevision = -1L;
    private boolean loadedFromLdap = true;

    @PostConstruct
    public void init() {
        this.log.info("Initializing ConfigurationFactory ...");
        this.isActive = new AtomicBoolean(true);
        try {
            this.log.info("---------PATH to file configuration: {}", (Object)APP_PROPERTIES_FILE);
            this.persistenceConfiguration = this.persistanceFactoryService.loadPersistenceConfiguration(APP_PROPERTIES_FILE);
            this.loadBaseConfiguration();
            String confDir = this.confDir();
            this.configFilePath = confDir + CONFIG_FILE_NAME;
            this.errorsFilePath = confDir + ERRORS_FILE_NAME;
            this.staticConfFilePath = confDir + STATIC_CONF_FILE_NAME;
            String certsDir = this.baseConfiguration.getString("certsDir");
            if (StringHelper.isEmpty((String)certsDir)) {
                certsDir = confDir;
            }
            this.webKeysFilePath = certsDir + File.separator + WEB_KEYS_FILE_NAME;
            this.saltFilePath = confDir + "salt";
            this.loadCryptoConfigurationSalt();
        }
        finally {
            this.isActive.set(false);
        }
    }

    public void onServletContextActivation(@Observes ServletContext context) {
        this.contextPath = context.getContextPath();
        this.facesMapping = "";
        ServletRegistration servletRegistration = context.getServletRegistration("Faces Servlet");
        if (servletRegistration == null) {
            return;
        }
        String[] mappings = servletRegistration.getMappings().toArray(new String[0]);
        if (mappings.length == 0) {
            return;
        }
        this.facesMapping = mappings[0].replaceAll("\\*", "");
    }

    public void initTimer() {
        this.log.debug("Initializing Configuration Timer");
        int delay = 30;
        this.timerEvent.fire((Object)new TimerEvent(new TimerSchedule(30, 30), (Object)new ConfigurationEvent(), new Annotation[]{Scheduled.Literal.INSTANCE}));
    }

    @Asynchronous
    public void reloadConfigurationTimerEvent(@Observes @Scheduled ConfigurationEvent configurationEvent) {
        if (this.isActive.get()) {
            return;
        }
        if (!this.isActive.compareAndSet(false, true)) {
            return;
        }
        try {
            this.reloadConfiguration();
        }
        catch (Exception ex) {
            this.log.error("Exception happened while reloading application configuration", (Throwable)ex);
        }
        finally {
            this.isActive.set(false);
        }
    }

    private void reloadConfiguration() {
        long lastModified;
        File baseConf;
        PersistenceConfiguration newPersistenceConfiguration = this.persistanceFactoryService.loadPersistenceConfiguration(APP_PROPERTIES_FILE);
        if (!(newPersistenceConfiguration == null || StringHelper.equalsIgnoreCase((String)this.persistenceConfiguration.getFileName(), (String)newPersistenceConfiguration.getFileName()) && newPersistenceConfiguration.getLastModifiedTime() <= this.persistenceConfiguration.getLastModifiedTime())) {
            this.persistenceConfiguration = newPersistenceConfiguration;
            this.event.select(new Annotation[]{LdapConfigurationReload.Literal.INSTANCE}).fire((Object)PERSISTENCE_CONFIGURATION_RELOAD_EVENT_TYPE);
        }
        if ((baseConf = new File(BASE_PROPERTIES_FILE)).exists() && (lastModified = baseConf.lastModified()) > this.baseConfigurationFileLastModifiedTime) {
            this.loadBaseConfiguration();
            this.event.select(new Annotation[]{BaseConfigurationReload.Literal.INSTANCE}).fire((Object)BASE_CONFIGURATION_RELOAD_EVENT_TYPE);
        }
        if (!this.loadedFromLdap) {
            return;
        }
        if (!this.isRevisionIncreased()) {
            return;
        }
        this.createFromDB(false);
    }

    private boolean isRevisionIncreased() {
        Conf persistenceConf = this.loadConfigurationFromPersistence("jansRevision");
        if (persistenceConf == null) {
            return false;
        }
        this.log.trace("LDAP revision: {}, server revision: {}", (Object)persistenceConf.getRevision(), (Object)this.loadedRevision);
        return persistenceConf.getRevision() > this.loadedRevision;
    }

    private String confDir() {
        String confDirectory = this.baseConfiguration.getString("confDir", null);
        if (StringUtils.isNotBlank((CharSequence)confDirectory)) {
            return confDirectory;
        }
        return DIR;
    }

    public FileConfiguration getBaseConfiguration() {
        return this.baseConfiguration;
    }

    @Produces
    @ApplicationScoped
    public PersistenceConfiguration getPersistenceConfiguration() {
        return this.persistenceConfiguration;
    }

    @Produces
    @ApplicationScoped
    public AppConfiguration getAppConfiguration() {
        return this.conf;
    }

    @Produces
    @ApplicationScoped
    public StaticConfiguration getStaticConfiguration() {
        return this.staticConf;
    }

    @Produces
    @ApplicationScoped
    public WebKeysConfiguration getWebKeysConfiguration() {
        return this.jwks;
    }

    @Produces
    @ApplicationScoped
    public ErrorResponseFactory getErrorResponseFactory() {
        return this.errorResponseFactory;
    }

    public BaseDnConfiguration getBaseDn() {
        return this.getStaticConfiguration().getBaseDn();
    }

    public String getCryptoConfigurationSalt() {
        return this.cryptoConfigurationSalt;
    }

    private boolean createFromFile() {
        return this.reloadConfFromFile() && this.reloadErrorsFromFile() && this.reloadStaticConfFromFile() && this.reloadWebkeyFromFile();
    }

    private boolean reloadWebkeyFromFile() {
        WebKeysConfiguration webKeysFromFile = this.loadWebKeysFromFile();
        if (webKeysFromFile != null) {
            this.log.info("Reloaded web keys from file: {}", (Object)this.webKeysFilePath);
            this.jwks = webKeysFromFile;
            return true;
        }
        this.log.error("Failed to load web keys configuration from file: {}", (Object)this.webKeysFilePath);
        return false;
    }

    private boolean reloadStaticConfFromFile() {
        StaticConfiguration staticConfFromFile = this.loadStaticConfFromFile();
        if (staticConfFromFile != null) {
            this.log.info("Reloaded static conf from file: {}", (Object)this.staticConfFilePath);
            this.staticConf = staticConfFromFile;
            return true;
        }
        this.log.error("Failed to load static configuration from file: {}", (Object)this.staticConfFilePath);
        return false;
    }

    private boolean reloadErrorsFromFile() {
        ErrorMessages errorsFromFile = this.loadErrorsFromFile();
        if (errorsFromFile != null) {
            this.log.info("Reloaded errors from file: {}", (Object)this.errorsFilePath);
            this.errorResponseFactory = new ErrorResponseFactory(errorsFromFile, this.conf);
            return true;
        }
        this.log.error("Failed to load errors from file: {}", (Object)this.errorsFilePath);
        return false;
    }

    private boolean reloadConfFromFile() {
        AppConfiguration configFromFile = this.loadConfFromFile();
        if (configFromFile != null) {
            this.log.info("Reloaded configuration from file: {}", (Object)this.configFilePath);
            this.conf = configFromFile;
            return true;
        }
        this.log.error("Failed to load configuration from file: {}", (Object)this.configFilePath);
        return false;
    }

    public boolean reloadConfFromLdap() {
        if (!this.isRevisionIncreased()) {
            return false;
        }
        return this.createFromDB(false);
    }

    protected boolean createFromDB(boolean recoverFromFiles) {
        this.log.info("Loading configuration from '{}' DB...", (Object)this.baseConfiguration.getString("persistence.type"));
        try {
            Conf c = this.loadConfigurationFromPersistence(new String[0]);
            if (c != null) {
                this.init(c);
                if (this.loaded) {
                    this.destroy(AppConfiguration.class);
                    this.destroy(StaticConfiguration.class);
                    this.destroy(WebKeysConfiguration.class);
                    this.destroy(ErrorResponseFactory.class);
                }
                this.loaded = true;
                this.configurationUpdateEvent.select(new Annotation[]{ConfigurationUpdate.Literal.INSTANCE}).fire((Object)this.conf);
                this.destroyCryptoProviderInstance();
                AbstractCryptoProvider newAbstractCryptoProvider = (AbstractCryptoProvider)this.abstractCryptoProviderInstance.get();
                this.cryptoProviderEvent.select(new Annotation[]{CryptoProviderEvent.Literal.INSTANCE}).fire((Object)newAbstractCryptoProvider);
                return true;
            }
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
        }
        if (recoverFromFiles) {
            this.log.info("Unable to find configuration in LDAP, try to load configuration from file system... ");
            if (this.createFromFile()) {
                this.loadedFromLdap = false;
                return true;
            }
        }
        return false;
    }

    public void destroy(Class<? extends Configuration> clazz) {
        Instance confInstance = this.configurationInstance.select(clazz, new Annotation[0]);
        this.configurationInstance.destroy((Object)((Configuration)confInstance.get()));
    }

    private void destroyCryptoProviderInstance() {
        this.log.trace("Destroyed crypto provider instance.");
        AbstractCryptoProvider abstractCryptoProvider = (AbstractCryptoProvider)this.abstractCryptoProviderInstance.get();
        this.abstractCryptoProviderInstance.destroy((Object)abstractCryptoProvider);
        CryptoProviderFactory.reset();
    }

    private Conf loadConfigurationFromPersistence(String ... returnAttributes) {
        PersistenceEntryManager ldapManager = (PersistenceEntryManager)this.persistenceEntryManagerInstance.get();
        String dn = this.baseConfiguration.getString("jansAuth_ConfigurationEntryDN");
        try {
            return (Conf)ldapManager.find((Object)dn, Conf.class, returnAttributes);
        }
        catch (BasePersistenceException ex) {
            if (!dn.contains("_test")) {
                ex.printStackTrace();
            }
            this.log.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    private void init(Conf conf) {
        this.initConfigurationConf(conf);
        this.loadedRevision = conf.getRevision();
    }

    private void initConfigurationConf(Conf conf) {
        if (conf.getDynamic() != null) {
            this.conf = conf.getDynamic();
        }
        if (conf.getStatics() != null) {
            this.staticConf = conf.getStatics();
        }
        this.initWebKeys(conf);
        if (conf.getErrors() != null) {
            this.errorResponseFactory = new ErrorResponseFactory(conf.getErrors(), conf.getDynamic());
        }
    }

    private void initWebKeys(Conf conf) {
        String jwksUri = conf.getDynamic().getJwksUri();
        if (jwksUri.startsWith(conf.getDynamic().getIssuer())) {
            if (conf.getWebKeys() != null) {
                this.jwks = conf.getWebKeys();
            } else {
                this.generateWebKeys();
            }
            return;
        }
        JSONObject keys = JwtUtil.getJSONWebKeys((String)jwksUri);
        this.log.trace("Downloaded external keys from {}, keys: {}", (Object)jwksUri, (Object)keys);
        JSONWebKeySet keySet = JSONWebKeySet.fromJSONObject((JSONObject)keys);
        this.jwks = new WebKeysConfiguration();
        this.jwks.setKeys(keySet.getKeys());
    }

    private void generateWebKeys() {
        this.log.info("Failed to load JWKS. Attempting to generate new JWKS...");
        String newWebKeys = null;
        try {
            AbstractCryptoProvider cryptoProvider = CryptoProviderFactory.getCryptoProvider((AppConfiguration)this.getAppConfiguration());
            JSONObject jsonObject = AbstractCryptoProvider.generateJwks((AbstractCryptoProvider)cryptoProvider, (AppConfiguration)this.getAppConfiguration());
            newWebKeys = jsonObject.toString();
            this.jwks = (WebKeysConfiguration)ServerUtil.createJsonMapper().readValue(newWebKeys, WebKeysConfiguration.class);
            Conf configuration = Objects.requireNonNull(this.loadConfigurationFromPersistence(new String[0]));
            configuration.setWebKeys(this.jwks);
            long nextRevision = configuration.getRevision() + 1L;
            configuration.setRevision(nextRevision);
            PersistenceEntryManager ldapManager = (PersistenceEntryManager)this.persistenceEntryManagerInstance.get();
            ldapManager.merge((Object)configuration);
            this.log.info("Generated new JWKS successfully.");
            if (this.log.isTraceEnabled()) {
                this.log.trace("JWKS keys: {}", configuration.getWebKeys().getKeys().stream().map(JSONWebKey::getKid).collect(Collectors.toList()));
                this.log.trace("KeyStore keys: {}", (Object)cryptoProvider.getKeys());
            }
        }
        catch (Exception ex2) {
            this.log.error("Failed to re-generate JWKS keys", (Throwable)ex2);
        }
    }

    private AppConfiguration loadConfFromFile() {
        try {
            return (AppConfiguration)ServerUtil.createJsonMapper().readValue(new File(this.configFilePath), AppConfiguration.class);
        }
        catch (Exception e) {
            this.log.warn(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private ErrorMessages loadErrorsFromFile() {
        try {
            return (ErrorMessages)ServerUtil.createJsonMapper().readValue(new File(this.errorsFilePath), ErrorMessages.class);
        }
        catch (Exception e) {
            this.log.warn(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private StaticConfiguration loadStaticConfFromFile() {
        try {
            return (StaticConfiguration)ServerUtil.createJsonMapper().readValue(new File(this.staticConfFilePath), StaticConfiguration.class);
        }
        catch (Exception e) {
            this.log.warn(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private WebKeysConfiguration loadWebKeysFromFile() {
        try {
            return (WebKeysConfiguration)ServerUtil.createJsonMapper().readValue(new File(this.webKeysFilePath), WebKeysConfiguration.class);
        }
        catch (Exception e) {
            this.log.warn(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private void loadBaseConfiguration() {
        this.baseConfiguration = this.createFileConfiguration(BASE_PROPERTIES_FILE, true);
        this.baseConfigurationFileLastModifiedTime = new File(BASE_PROPERTIES_FILE).lastModified();
    }

    public void loadCryptoConfigurationSalt() {
        try {
            FileConfiguration cryptoConfiguration = this.createFileConfiguration(this.saltFilePath, true);
            this.cryptoConfigurationSalt = cryptoConfiguration.getString("encodeSalt");
        }
        catch (Exception ex) {
            if (this.log.isErrorEnabled()) {
                this.log.error("Failed to load configuration from {}", (Object)this.saltFilePath, (Object)ex);
            }
            throw new ConfigurationException("Failed to load configuration from " + this.saltFilePath, (Throwable)ex);
        }
    }

    private FileConfiguration createFileConfiguration(String fileName, boolean isMandatory) {
        try {
            return new FileConfiguration(fileName);
        }
        catch (Exception ex) {
            if (isMandatory) {
                this.log.error("Failed to load configuration from {}", (Object)fileName, (Object)ex);
                throw new ConfigurationException("Failed to load configuration from " + fileName, (Throwable)ex);
            }
            return null;
        }
    }

    public String getFacesMapping() {
        return this.facesMapping;
    }

    public String getContextPath() {
        return this.contextPath;
    }
}

