/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.rate;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.github.bucket4j.Bandwidth;
import io.github.bucket4j.Bucket;
import io.jans.as.client.RegisterRequest;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.server.rate.RateLimitType;
import io.jans.as.server.rate.RateLimitedException;
import io.jans.as.server.register.ws.rs.RegisterService;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.json.JSONObject;
import org.slf4j.Logger;

@ApplicationScoped
public class RateLimitService {
    private static final int DEFAULT_REQUEST_LIMIT = 10;
    private static final int DEFAULT_PERIOD_LIMIT = 60;
    private final Cache<String, Bucket> buckets = CacheBuilder.newBuilder().expireAfterWrite(2L, TimeUnit.MINUTES).weakKeys().build();
    @Inject
    private Logger log;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private RegisterService registerService;

    public void validateRateLimitForRegister(String key) throws RateLimitedException {
        int requestLimit = this.getRequestLimit(this.appConfiguration.getRateLimitRegistrationRequestCount());
        int periodLimit = this.getPeriodLimit(this.appConfiguration.getRateLimitRegistrationPeriodInSeconds());
        try {
            Bucket bucket = (Bucket)this.buckets.get((Object)key, () -> this.newBucket(requestLimit, periodLimit));
            if (!bucket.tryConsume(1L)) {
                String msg = String.format("Rate limited '/register', key %s. Exceeds limit %s requests per %s seconds.", key, requestLimit, periodLimit);
                this.log.debug(msg);
                throw new RateLimitedException(RateLimitType.REGISTRATION, msg);
            }
        }
        catch (ExecutionException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }

    private int getRequestLimit(Integer requestLimit) {
        if (requestLimit == null || requestLimit <= 0) {
            return 10;
        }
        return requestLimit;
    }

    private int getPeriodLimit(Integer periodInSeconds) {
        if (periodInSeconds == null || periodInSeconds <= 0) {
            periodInSeconds = 60;
        }
        return periodInSeconds;
    }

    private Bucket newBucket(int requestLimit, int periodInSeconds) {
        return Bucket.builder().addLimit(Bandwidth.builder().capacity((long)requestLimit).refillGreedy((long)requestLimit, Duration.ofSeconds(periodInSeconds)).build()).build();
    }

    public RegisterRequest parseRegisterRequest(String body) {
        try {
            JSONObject requestObject = this.registerService.parseRequestObjectWithoutValidation(body);
            return RegisterRequest.fromJson((JSONObject)requestObject);
        }
        catch (Exception e) {
            this.log.error("Failed to parse registration request.", (Throwable)e);
            return null;
        }
    }
}

