/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.register.ws.rs;

import com.codahale.metrics.Timer;
import io.jans.as.server.register.ws.rs.RegisterRestWebService;
import io.jans.as.server.register.ws.rs.action.RegisterCreateAction;
import io.jans.as.server.register.ws.rs.action.RegisterDeleteAction;
import io.jans.as.server.register.ws.rs.action.RegisterReadAction;
import io.jans.as.server.register.ws.rs.action.RegisterUpdateAction;
import io.jans.as.server.service.MetricService;
import io.jans.model.metric.MetricType;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;

@Path(value="/")
public class RegisterRestWebServiceImpl
implements RegisterRestWebService {
    @Inject
    private MetricService metricService;
    @Inject
    private RegisterCreateAction registerCreateAction;
    @Inject
    private RegisterUpdateAction registerUpdateAction;
    @Inject
    private RegisterReadAction registerReadAction;
    @Inject
    private RegisterDeleteAction registerDeleteAction;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response requestRegister(String requestParams, HttpServletRequest httpRequest, SecurityContext securityContext) {
        Timer.Context timerContext = this.metricService.getTimer(MetricType.DYNAMIC_CLIENT_REGISTRATION_RATE).time();
        try {
            Response response = this.registerCreateAction.createClient(requestParams, httpRequest, securityContext);
            return response;
        }
        finally {
            timerContext.stop();
        }
    }

    @Override
    public Response requestClientUpdate(String requestParams, String clientId, String authorization, HttpServletRequest httpRequest, SecurityContext securityContext) {
        return this.registerUpdateAction.updateClient(requestParams, clientId, authorization, httpRequest, securityContext);
    }

    @Override
    public Response requestClientRead(String clientId, String authorization, HttpServletRequest httpRequest, SecurityContext securityContext) {
        return this.registerReadAction.readClient(clientId, authorization, httpRequest, securityContext);
    }

    @Override
    public Response delete(String clientId, String authorization, HttpServletRequest httpRequest, SecurityContext securityContext) {
        return this.registerDeleteAction.delete(clientId, authorization, httpRequest, securityContext);
    }
}

