/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.register.ws.rs;

import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.model.crypto.AbstractCryptoProvider;
import io.jans.as.model.crypto.signature.AlgorithmFamily;
import io.jans.as.model.crypto.signature.SignatureAlgorithm;
import io.jans.as.model.exception.CryptoProviderException;
import io.jans.as.model.exception.InvalidJwtException;
import io.jans.as.model.jwt.Jwt;
import io.jans.as.model.jwt.JwtClaims;
import io.jans.as.model.register.RegisterRequestParam;
import io.jans.as.model.ssa.SsaValidationConfig;
import io.jans.as.model.ssa.SsaValidationType;
import io.jans.as.model.util.StringUtils;
import io.jans.as.server.register.ws.rs.SsaValidationConfigContext;
import io.jans.as.server.service.net.UriService;
import jakarta.ejb.Stateless;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.json.JSONObject;
import org.slf4j.Logger;

@Stateless
@Named
public class SsaValidationConfigService {
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private Logger log;
    @Inject
    private AbstractCryptoProvider cryptoProvider;
    @Inject
    private UriService uriService;

    public List<SsaValidationConfig> getByIssuer(String issuer, SsaValidationType type) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)issuer)) {
            return new ArrayList<SsaValidationConfig>();
        }
        List all = this.appConfiguration.getDcrSsaValidationConfigs();
        return all.stream().filter(s -> s.getIssuers().contains(issuer) && s.getType() == type).collect(Collectors.toList());
    }

    public List<SsaValidationConfig> getByIssuer(Jwt jwt, SsaValidationType type) {
        String issuer = jwt.getClaims().getClaimAsString("iss");
        return this.getByIssuer(issuer, type);
    }

    public boolean isHmacValid(SsaValidationConfigContext context) {
        List<SsaValidationConfig> byIssuer = this.getByIssuer(context.getJwt(), context.getType());
        if (byIssuer.isEmpty()) {
            return false;
        }
        for (SsaValidationConfig config : byIssuer) {
            if (!this.isHmacValid(context.getJwt(), config)) continue;
            context.setSuccessfulConfig(config);
            return true;
        }
        return false;
    }

    private boolean isHmacValid(Jwt jwt, SsaValidationConfig config) {
        String hmacSecret = config.getSharedSecret();
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)hmacSecret)) {
            this.log.trace("No hmacSecret provided in SsaValidationConfig: {}", (Object)config);
            return false;
        }
        SignatureAlgorithm signatureAlgorithm = jwt.getHeader().getSignatureAlgorithm();
        try {
            boolean validSignature = this.cryptoProvider.verifySignature(jwt.getSigningInput(), jwt.getEncodedSignature(), null, null, hmacSecret, signatureAlgorithm);
            this.log.trace("Request object validation result: {}, SsaValidationConfig: {}", (Object)validSignature, (Object)config);
            if (validSignature) {
                this.log.trace("Request object is validated successfully. SsaValidationConfig: {}", (Object)config);
                return true;
            }
        }
        catch (CryptoProviderException | InvalidJwtException e) {
            this.log.trace("Unable to validate jwt with ssaValidationConfig: " + config, e);
        }
        return false;
    }

    public boolean hasValidSignature(SsaValidationConfigContext context) {
        List<SsaValidationConfig> byIssuer = this.getByIssuer(context.getJwt(), context.getType());
        if (byIssuer.isEmpty()) {
            return false;
        }
        for (SsaValidationConfig config : byIssuer) {
            if (!this.isSignatureValid(context.getJwt(), config)) continue;
            context.setSuccessfulConfig(config);
            return true;
        }
        return false;
    }

    private boolean isSignatureValid(Jwt jwt, SsaValidationConfig config) {
        try {
            JSONObject jwks = this.loadJwks(config);
            if (jwks == null || jwks.isEmpty()) {
                this.log.error("Unable to load jwks for ssaValidationConfig: {}", (Object)config);
                return false;
            }
            this.log.trace("Validating request object with jwks: {} ...", (Object)jwks);
            return this.cryptoProvider.verifySignature(jwt.getSigningInput(), jwt.getEncodedSignature(), jwt.getHeader().getKeyId(), jwks, null, jwt.getHeader().getSignatureAlgorithm());
        }
        catch (CryptoProviderException | InvalidJwtException e) {
            this.log.trace("Unable to validate jwt with ssaValidationConfig: " + config, e);
            return false;
        }
    }

    private JSONObject loadJwks(SsaValidationConfig config) {
        JSONObject responseJson;
        String jwksEndpoint;
        JSONObject jwks = null;
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)config.getJwksUri())) {
            jwks = this.uriService.loadJson(config.getJwksUri());
        }
        if (jwks == null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)config.getJwks())) {
            jwks = new JSONObject(config.getJwks());
        }
        if (jwks == null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)config.getConfigurationEndpoint()) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)config.getConfigurationEndpointClaim()) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(jwksEndpoint = (responseJson = this.uriService.loadJson(config.getConfigurationEndpoint())).optString(config.getConfigurationEndpointClaim())))) {
            jwks = this.uriService.loadJson(jwksEndpoint);
        }
        return jwks;
    }

    public JSONObject validateSsaForBuiltIn(Jwt ssa) throws InvalidJwtException {
        this.log.debug("Validating ssa with softwareStatementValidationType=builtin validation ...");
        List<SsaValidationConfig> byIssuer = this.getByIssuer(ssa, SsaValidationType.SSA);
        SignatureAlgorithm signatureAlgorithm = ssa.getHeader().getSignatureAlgorithm();
        boolean isHmac = AlgorithmFamily.HMAC.equals((Object)signatureAlgorithm.getFamily());
        for (SsaValidationConfig config : byIssuer) {
            if (isHmac && this.isHmacValid(ssa, config)) {
                return this.prepareSsaJsonObject(ssa.getClaims(), config);
            }
            if (isHmac || !this.isSignatureValid(ssa, config)) continue;
            return this.prepareSsaJsonObject(ssa.getClaims(), config);
        }
        return null;
    }

    public JSONObject prepareSsaJsonObject(JwtClaims ssa, SsaValidationConfig config) throws InvalidJwtException {
        JSONObject result = ssa.toJsonObject();
        if (!config.getScopes().isEmpty()) {
            this.log.trace("Set scopes from ssaValidationConfig: {}", (Object)config);
            result.putOpt(RegisterRequestParam.SCOPE.toString(), (Object)StringUtils.implode((Collection)config.getScopes(), (String)" "));
        }
        if (!config.getAllowedClaims().isEmpty()) {
            this.log.trace("Set claims from ssaValidationConfig: {}", (Object)config);
            result.putOpt(RegisterRequestParam.CLAIMS.toString(), (Object)StringUtils.implode((Collection)config.getAllowedClaims(), (String)" "));
        }
        return result;
    }
}

