/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.service;

import com.google.common.collect.Sets;
import io.jans.as.common.model.common.User;
import io.jans.as.common.model.registration.Client;
import io.jans.as.common.model.session.SessionId;
import io.jans.as.common.util.RedirectUri;
import io.jans.as.model.authorize.AuthorizeErrorResponseType;
import io.jans.as.model.ciba.PushErrorResponseType;
import io.jans.as.model.common.Prompt;
import io.jans.as.model.common.ResponseMode;
import io.jans.as.model.common.ResponseType;
import io.jans.as.model.config.WebKeysConfiguration;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.model.crypto.AbstractCryptoProvider;
import io.jans.as.model.crypto.signature.SignatureAlgorithm;
import io.jans.as.model.error.ErrorResponseFactory;
import io.jans.as.model.error.IErrorType;
import io.jans.as.model.exception.CryptoProviderException;
import io.jans.as.model.jwk.Algorithm;
import io.jans.as.model.jwk.JSONWebKeySet;
import io.jans.as.model.jwk.KeyOpsType;
import io.jans.as.model.jwk.Use;
import io.jans.as.model.util.StringUtils;
import io.jans.as.persistence.model.Scope;
import io.jans.as.server.auth.Authenticator;
import io.jans.as.server.ciba.CIBAPingCallbackService;
import io.jans.as.server.ciba.CIBAPushErrorService;
import io.jans.as.server.model.common.CibaRequestCacheControl;
import io.jans.as.server.model.common.CibaRequestStatus;
import io.jans.as.server.model.common.DeviceAuthorizationCacheControl;
import io.jans.as.server.model.common.DeviceAuthorizationStatus;
import io.jans.as.server.security.Identity;
import io.jans.as.server.service.ClientAuthorizationsService;
import io.jans.as.server.service.ClientService;
import io.jans.as.server.service.CookieService;
import io.jans.as.server.service.DeviceAuthorizationService;
import io.jans.as.server.service.RequestParameterService;
import io.jans.as.server.service.ScopeService;
import io.jans.as.server.service.ServerCryptoProvider;
import io.jans.as.server.service.SessionIdService;
import io.jans.as.server.service.ciba.CibaRequestService;
import io.jans.jsf2.message.FacesMessages;
import io.jans.jsf2.service.FacesService;
import io.jans.util.security.StringEncrypter;
import jakarta.enterprise.context.RequestScoped;
import jakarta.faces.application.FacesMessage;
import jakarta.faces.context.ExternalContext;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;

@RequestScoped
public class AuthorizeService {
    @Inject
    private Logger log;
    @Inject
    private ClientService clientService;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private SessionIdService sessionIdService;
    @Inject
    private CookieService cookieService;
    @Inject
    private ClientAuthorizationsService clientAuthorizationsService;
    @Inject
    private Identity identity;
    @Inject
    private Authenticator authenticator;
    @Inject
    private FacesService facesService;
    @Inject
    private FacesMessages facesMessages;
    @Inject
    private ExternalContext externalContext;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private ScopeService scopeService;
    @Inject
    private RequestParameterService requestParameterService;
    @Inject
    private CIBAPingCallbackService cibaPingCallbackService;
    @Inject
    private CIBAPushErrorService cibaPushErrorService;
    @Inject
    private CibaRequestService cibaRequestService;
    @Inject
    private DeviceAuthorizationService deviceAuthorizationService;
    @Inject
    private AbstractCryptoProvider cryptoProvider;
    @Inject
    private WebKeysConfiguration webKeysConfiguration;

    public SessionId getSession() {
        return this.getSession(null);
    }

    public SessionId getSession(String sessionId) {
        SessionId dbSessionId;
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)sessionId) && org.apache.commons.lang3.StringUtils.isBlank((CharSequence)(sessionId = this.cookieService.getSessionIdFromCookie()))) {
            return null;
        }
        if (!this.identity.isLoggedIn()) {
            this.authenticator.authenticateBySessionId(sessionId);
        }
        if ((dbSessionId = this.sessionIdService.getSessionId(sessionId)) == null) {
            this.identity.logout();
        }
        return dbSessionId;
    }

    public void permissionGranted(HttpServletRequest httpRequest, SessionId session) {
        this.log.trace("permissionGranted");
        try {
            Map<String, String> sessionAttribute;
            boolean persistDuringImplicitFlow;
            User user = this.sessionIdService.getUser(session);
            if (user == null) {
                this.log.debug("Permission denied. Failed to find session user: userDn = {}", (Object)session.getUserDn());
                this.permissionDenied(session);
                return;
            }
            String clientId = (String)session.getSessionAttributes().get("client_id");
            Client client = this.clientService.getClient(clientId);
            if (client == null) {
                this.log.debug("Permission denied. Failed to find client by id: {}", (Object)clientId);
                this.permissionDenied(session);
                return;
            }
            String scope = (String)session.getSessionAttributes().get("scope");
            String authorizationDetails = (String)session.getSessionAttributes().get("authorization_details");
            HashSet scopeSet = Sets.newHashSet((Iterable)StringUtils.spaceSeparatedToList((String)scope));
            String responseType = (String)session.getSessionAttributes().get("response_type");
            boolean bl = persistDuringImplicitFlow = !ResponseType.isImplicitFlow((String)responseType);
            if (!client.getTrustedClient() && persistDuringImplicitFlow && client.getPersistClientAuthorizations()) {
                this.clientAuthorizationsService.add(user.getAttribute("inum"), client.getClientId(), scopeSet, authorizationDetails);
            }
            session.addPermission(clientId, Boolean.valueOf(true), (Set)scopeSet);
            this.sessionIdService.updateSessionId(session);
            this.identity.setSessionId(session);
            if (BooleanUtils.isFalse((Boolean)this.appConfiguration.getInvalidateSessionCookiesAfterAuthorizationFlow())) {
                this.cookieService.createSessionIdCookie(session, false);
            }
            if ((sessionAttribute = this.requestParameterService.getAllowedParameters(session.getSessionAttributes())).containsKey("prompt")) {
                List prompts = Prompt.fromString((String)sessionAttribute.get("prompt"), (String)" ");
                prompts.remove(Prompt.LOGIN);
                prompts.remove(Prompt.CONSENT);
                sessionAttribute.put("prompt", StringUtils.implodeEnum((List)prompts, (String)" "));
            }
            String parametersAsString = this.requestParameterService.parametersAsString(sessionAttribute);
            String uri = httpRequest.getContextPath() + "/restv1/authorize?" + parametersAsString;
            this.log.trace("permissionGranted, redirectTo: {}", (Object)uri);
            boolean sessionInvalidated = this.invalidateSessionCookiesIfNeeded();
            if (sessionInvalidated && !uri.contains("session_id") && BooleanUtils.isTrue((Boolean)this.appConfiguration.getSessionIdRequestParameterEnabled())) {
                uri = uri + "&session_id=" + session.getId();
            }
            this.facesService.redirectToExternalURL(uri);
        }
        catch (Exception e) {
            this.log.error("Failed to grant permission", (Throwable)e);
            this.showErrorPage("login.failedToGrantPermission");
        }
    }

    public void permissionDenied(SessionId session) {
        try {
            String authReqId;
            CibaRequestCacheControl request;
            this.log.trace("permissionDenied");
            this.invalidateSessionCookiesIfNeeded();
            if (session == null) {
                this.authenticationFailedSessionInvalid();
                return;
            }
            String baseRedirectUri = (String)session.getSessionAttributes().get("redirect_uri");
            String state = (String)session.getSessionAttributes().get("state");
            ResponseMode responseMode = ResponseMode.fromString((String)((String)session.getSessionAttributes().get("response_mode")));
            List responseType = ResponseType.fromString((String)((String)session.getSessionAttributes().get("response_type")), (String)" ");
            RedirectUri redirectUri = new RedirectUri(baseRedirectUri, responseType, responseMode);
            redirectUri.parseQueryString(this.errorResponseFactory.getErrorAsQueryString((IErrorType)AuthorizeErrorResponseType.ACCESS_DENIED, state));
            Map<String, String> sessionAttribute = this.requestParameterService.getAllowedParameters(session.getSessionAttributes());
            if (sessionAttribute.containsKey("auth_req_id") && (request = this.cibaRequestService.getCibaRequest(authReqId = sessionAttribute.get("auth_req_id"))) != null && request.getClient() != null) {
                if (request.getStatus() == CibaRequestStatus.PENDING) {
                    this.cibaRequestService.removeCibaRequest(authReqId);
                }
                switch (request.getClient().getBackchannelTokenDeliveryMode()) {
                    case POLL: {
                        request.setStatus(CibaRequestStatus.DENIED);
                        request.setTokensDelivered(false);
                        this.cibaRequestService.update(request);
                        break;
                    }
                    case PING: {
                        request.setStatus(CibaRequestStatus.DENIED);
                        request.setTokensDelivered(false);
                        this.cibaRequestService.update(request);
                        this.cibaPingCallbackService.pingCallback(request.getAuthReqId(), request.getClient().getBackchannelClientNotificationEndpoint(), request.getClientNotificationToken());
                        break;
                    }
                    case PUSH: {
                        this.cibaPushErrorService.pushError(request.getAuthReqId(), request.getClient().getBackchannelClientNotificationEndpoint(), request.getClientNotificationToken(), PushErrorResponseType.ACCESS_DENIED, "The end-user denied the authorization request.");
                    }
                }
            }
            if (sessionAttribute.containsKey("user_code")) {
                this.processDeviceAuthDeniedResponse(sessionAttribute);
            }
            if (responseMode == ResponseMode.JWT) {
                String clientId = (String)session.getSessionAttributes().get("client_id");
                Client client = this.clientService.getClient(clientId);
                this.facesService.redirectToExternalURL(this.createJarmRedirectUri(redirectUri, client));
            } else {
                this.facesService.redirectToExternalURL(redirectUri.toString());
            }
        }
        catch (Exception e) {
            this.log.error("Unable to perform permission deny", (Throwable)e);
            this.showErrorPage("login.failedToDeny");
        }
    }

    private String createJarmRedirectUri(RedirectUri redirectUri, Client client) {
        Object jarmRedirectUri = redirectUri.toString();
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.fromString((String)client.getAttributes().getAuthorizationSignedResponseAlg());
        redirectUri.setSignatureAlgorithm(signatureAlgorithm);
        redirectUri.addResponseParameter("error", "access_denied");
        redirectUri.addResponseParameter("error_description", "User Denied the Access");
        redirectUri.setIssuer(this.appConfiguration.getIssuer());
        redirectUri.setAudience(client.getClientId());
        redirectUri.setCryptoProvider(this.cryptoProvider);
        String keyId = null;
        try {
            String clientSecret = this.clientService.decryptSecret(client.getClientSecret());
            redirectUri.setSharedSecret(clientSecret);
            keyId = new ServerCryptoProvider(this.cryptoProvider).getKeyId((JSONWebKeySet)this.webKeysConfiguration, Algorithm.fromString((String)signatureAlgorithm.getName()), Use.SIGNATURE, KeyOpsType.CONNECT);
        }
        catch (CryptoProviderException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        catch (StringEncrypter.EncryptionException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        redirectUri.setKeyId(keyId);
        String jarmQueryString = redirectUri.getQueryString();
        this.log.info("The JARM Query Response: {}", (Object)jarmQueryString);
        jarmRedirectUri = (String)jarmRedirectUri + jarmQueryString;
        return jarmRedirectUri;
    }

    private void authenticationFailedSessionInvalid() {
        this.showErrorPage("login.errorSessionInvalidMessage");
    }

    private void showErrorPage(String errorCode) {
        this.log.debug("Redirect to /error.xhtml page with {} error code.", (Object)errorCode);
        this.facesMessages.add(FacesMessage.SEVERITY_ERROR, errorCode);
        this.facesService.redirect("/error.xhtml");
    }

    public List<Scope> getScopes() {
        SessionId session = this.getSession();
        String scope = (String)session.getSessionAttributes().get("scope");
        return this.getScopes(scope);
    }

    public List<Scope> getScopes(String scopes) {
        ArrayList<Scope> result = new ArrayList<Scope>();
        if (scopes != null && !scopes.isEmpty()) {
            String[] scopesName;
            for (String scopeName : scopesName = scopes.split(" ")) {
                Scope s = this.scopeService.getScopeById(scopeName);
                if (s == null || s.getDescription() == null) continue;
                result.add(s);
            }
        }
        return result;
    }

    private boolean invalidateSessionCookiesIfNeeded() {
        if (BooleanUtils.isTrue((Boolean)this.appConfiguration.getInvalidateSessionCookiesAfterAuthorizationFlow())) {
            return this.invalidateSessionCookies();
        }
        return false;
    }

    private boolean invalidateSessionCookies() {
        try {
            if (this.externalContext.getResponse() instanceof HttpServletResponse) {
                HttpServletResponse httpResponse = (HttpServletResponse)this.externalContext.getResponse();
                this.log.trace("Invalidated {} cookie.", (Object)"session_id");
                httpResponse.addHeader("Set-Cookie", "session_id=deleted; Path=/; Secure; HttpOnly; Expires=Thu, 01 Jan 1970 00:00:01 GMT;");
                this.log.trace("Invalidated {} cookie.", (Object)"consent_session_id");
                httpResponse.addHeader("Set-Cookie", "consent_session_id=deleted; Path=/; Secure; HttpOnly; Expires=Thu, 01 Jan 1970 00:00:01 GMT;");
                return true;
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    private void processDeviceAuthDeniedResponse(Map<String, String> sessionAttribute) {
        String userCode = sessionAttribute.get("user_code");
        DeviceAuthorizationCacheControl cacheData = this.deviceAuthorizationService.getDeviceAuthzByUserCode(userCode);
        if (cacheData != null && cacheData.getStatus() == DeviceAuthorizationStatus.PENDING) {
            cacheData.setStatus(DeviceAuthorizationStatus.DENIED);
            this.deviceAuthorizationService.saveInCache(cacheData, true, false);
            this.deviceAuthorizationService.removeDeviceAuthRequestInCache(userCode, null);
        }
    }
}

