/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.service;

import io.jans.as.common.model.registration.Client;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.server.service.BaseAuthFilterService;
import io.jans.orm.PersistenceEntryManager;
import io.jans.orm.exception.operation.SearchException;
import jakarta.annotation.PostConstruct;
import jakarta.ejb.DependsOn;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

@ApplicationScoped
@DependsOn(value={"appInitializer"})
@Named
public class ClientFilterService
extends BaseAuthFilterService {
    @Inject
    private PersistenceEntryManager ldapEntryManager;
    @Inject
    private AppConfiguration appConfiguration;

    @PostConstruct
    public void init() {
        super.init(this.appConfiguration.getClientAuthenticationFilters(), Boolean.TRUE.equals(this.appConfiguration.getClientAuthenticationFiltersEnabled()), false);
    }

    @Override
    public String processAuthenticationFilter(BaseAuthFilterService.AuthenticationFilterWithParameters authenticationFilterWithParameters, Map<?, ?> attributeValues) throws SearchException {
        if (attributeValues == null) {
            return null;
        }
        Map<String, String> normalizedAttributeValues = ClientFilterService.normalizeAttributeMap(attributeValues);
        String resultDn = this.loadEntryDN(this.ldapEntryManager, Client.class, authenticationFilterWithParameters, normalizedAttributeValues);
        if (StringUtils.isBlank((CharSequence)resultDn)) {
            return null;
        }
        return resultDn;
    }
}

