/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.service;

import com.google.common.collect.Lists;
import io.jans.as.common.service.AttributeService;
import io.jans.as.model.common.FeatureFlagType;
import io.jans.as.model.common.GrantType;
import io.jans.as.model.common.Prompt;
import io.jans.as.model.common.ScopeType;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.model.util.StringUtils;
import io.jans.as.model.util.Util;
import io.jans.as.persistence.model.Scope;
import io.jans.as.persistence.model.ScopeAttributes;
import io.jans.as.server.ciba.CIBAConfigurationService;
import io.jans.as.server.service.LocalResponseCache;
import io.jans.as.server.service.ScopeService;
import io.jans.as.server.service.external.ExternalAuthenticationService;
import io.jans.as.server.service.external.ExternalAuthzDetailTypeService;
import io.jans.as.server.service.external.ExternalDynamicScopeService;
import io.jans.as.server.servlet.OpenIdConfiguration;
import io.jans.model.JansAttribute;
import jakarta.ejb.Stateless;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;

@Stateless
@Named
public class DiscoveryService {
    @Inject
    private Logger log;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private ExternalAuthzDetailTypeService externalAuthzDetailTypeService;
    @Inject
    private CIBAConfigurationService cibaConfigurationService;
    @Inject
    private LocalResponseCache localResponseCache;
    @Inject
    private ExternalAuthenticationService externalAuthenticationService;
    @Inject
    private ExternalDynamicScopeService externalDynamicScopeService;
    @Inject
    private ScopeService scopeService;
    @Inject
    private AttributeService attributeService;

    public JSONObject process() {
        Map acrMappings;
        boolean isEndSessionEnabled;
        JSONObject jsonObj = new JSONObject();
        jsonObj.put("issuer", (Object)this.appConfiguration.getIssuer());
        jsonObj.put("authorization_endpoint", (Object)this.appConfiguration.getAuthorizationEndpoint());
        jsonObj.put("authorization_challenge_endpoint", (Object)this.appConfiguration.getAuthorizationChallengeEndpoint());
        jsonObj.put("token_endpoint", (Object)this.appConfiguration.getTokenEndpoint());
        jsonObj.put("jwks_uri", (Object)this.appConfiguration.getJwksUri());
        jsonObj.put("archived_jwks_uri", (Object)this.appConfiguration.getArchivedJwksUri());
        jsonObj.put("check_session_iframe", (Object)this.appConfiguration.getCheckSessionIFrame());
        if (this.appConfiguration.isFeatureEnabled(FeatureFlagType.STATUS_LIST)) {
            jsonObj.put("status_list_endpoint", (Object)this.getStatusListEndpoint());
            jsonObj.put("status_list_aggregation_endpoint", (Object)this.getStatusListAggregationEndpoint());
        }
        if (this.appConfiguration.isFeatureEnabled(FeatureFlagType.ACCESS_EVALUATION)) {
            jsonObj.put("access_evaluation_v1_endpoint", (Object)DiscoveryService.getAccessEvaluationV1Endpoint(this.appConfiguration));
        }
        if (this.appConfiguration.isFeatureEnabled(FeatureFlagType.REVOKE_TOKEN)) {
            jsonObj.put("revocation_endpoint", (Object)this.appConfiguration.getTokenRevocationEndpoint());
        }
        if (this.appConfiguration.isFeatureEnabled(FeatureFlagType.GLOBAL_TOKEN_REVOCATION)) {
            jsonObj.put("global_token_revocation_endpoint", (Object)this.endpointUrl("/global-token-revocation"));
        }
        if (this.appConfiguration.isFeatureEnabled(FeatureFlagType.USERINFO)) {
            jsonObj.put("userinfo_endpoint", (Object)this.appConfiguration.getUserInfoEndpoint());
        }
        if (this.appConfiguration.isFeatureEnabled(FeatureFlagType.CLIENTINFO)) {
            jsonObj.put("clientinfo_endpoint", (Object)this.appConfiguration.getClientInfoEndpoint());
        }
        if (isEndSessionEnabled = this.appConfiguration.isFeatureEnabled(FeatureFlagType.END_SESSION)) {
            jsonObj.put("end_session_endpoint", (Object)this.appConfiguration.getEndSessionEndpoint());
        }
        if (this.appConfiguration.isFeatureEnabled(FeatureFlagType.REGISTRATION)) {
            jsonObj.put("registration_endpoint", (Object)this.appConfiguration.getRegistrationEndpoint());
        }
        if (this.appConfiguration.isFeatureEnabled(FeatureFlagType.ID_GENERATION)) {
            jsonObj.put("id_generation_endpoint", (Object)this.appConfiguration.getIdGenerationEndpoint());
        }
        if (this.appConfiguration.isFeatureEnabled(FeatureFlagType.INTROSPECTION)) {
            jsonObj.put("introspection_endpoint", (Object)this.appConfiguration.getIntrospectionEndpoint());
        }
        if (this.appConfiguration.isFeatureEnabled(FeatureFlagType.DEVICE_AUTHZ)) {
            jsonObj.put("device_authorization_endpoint", (Object)this.appConfiguration.getDeviceAuthzEndpoint());
        }
        if (this.appConfiguration.isFeatureEnabled(FeatureFlagType.PAR)) {
            jsonObj.put("pushed_authorization_request_endpoint", (Object)this.appConfiguration.getParEndpoint());
            jsonObj.put("require_pushed_authorization_requests", (Object)this.appConfiguration.getRequirePar());
        }
        JSONArray responseTypesSupported = new JSONArray();
        for (Set responseTypes : this.appConfiguration.getResponseTypesSupported()) {
            responseTypesSupported.put((Object)StringUtils.implode((Collection)responseTypes, (String)" "));
        }
        if (responseTypesSupported.length() > 0) {
            jsonObj.put("response_types_supported", (Object)responseTypesSupported);
        }
        JSONArray promptValuesSupported = new JSONArray();
        promptValuesSupported.putAll((Collection)Arrays.stream(Prompt.values()).map(Prompt::getParamName).collect(Collectors.toList()));
        jsonObj.put("prompt_values_supported", (Object)promptValuesSupported);
        ArrayList<String> listResponseModesSupported = new ArrayList<String>();
        if (this.appConfiguration.getResponseModesSupported() != null) {
            for (Object responseMode : this.appConfiguration.getResponseModesSupported()) {
                listResponseModesSupported.add(responseMode.getValue());
            }
        }
        if (!listResponseModesSupported.isEmpty()) {
            Util.putArray((JSONObject)jsonObj, listResponseModesSupported, (String)"response_modes_supported");
        }
        ArrayList<String> listGrantTypesSupported = new ArrayList<String>();
        for (GrantType grantType : this.appConfiguration.getGrantTypesSupported()) {
            listGrantTypesSupported.add(grantType.getValue());
        }
        if (!listGrantTypesSupported.isEmpty()) {
            Util.putArray((JSONObject)jsonObj, listGrantTypesSupported, (String)"grant_types_supported");
        }
        jsonObj.put("auth_level_mapping", (Object)this.createAuthLevelMapping());
        Util.putArray((JSONObject)jsonObj, this.getAcrValuesList(), (String)"acr_values_supported");
        Util.putArray((JSONObject)jsonObj, (List)Lists.newArrayList(this.externalAuthzDetailTypeService.getSupportedAuthzDetailsTypes()), (String)"authorization_details_types_supported");
        Util.putArray((JSONObject)jsonObj, (List)this.appConfiguration.getSubjectTypesSupported(), (String)"subject_types_supported");
        Util.putArray((JSONObject)jsonObj, (List)this.appConfiguration.getAuthorizationSigningAlgValuesSupported(), (String)"authorization_signing_alg_values_supported");
        Util.putArray((JSONObject)jsonObj, (List)this.appConfiguration.getAuthorizationEncryptionAlgValuesSupported(), (String)"authorization_encryption_alg_values_supported");
        Util.putArray((JSONObject)jsonObj, (List)this.appConfiguration.getAuthorizationEncryptionEncValuesSupported(), (String)"authorization_encryption_enc_values_supported");
        Util.putArray((JSONObject)jsonObj, (List)this.appConfiguration.getUserInfoSigningAlgValuesSupported(), (String)"userinfo_signing_alg_values_supported");
        Util.putArray((JSONObject)jsonObj, (List)this.appConfiguration.getUserInfoEncryptionAlgValuesSupported(), (String)"userinfo_encryption_alg_values_supported");
        Util.putArray((JSONObject)jsonObj, (List)this.appConfiguration.getUserInfoEncryptionEncValuesSupported(), (String)"userinfo_encryption_enc_values_supported");
        Util.putArray((JSONObject)jsonObj, (List)this.appConfiguration.getIntrospectionSigningAlgValuesSupported(), (String)"introspection_signing_alg_values_supported");
        Util.putArray((JSONObject)jsonObj, (List)this.appConfiguration.getIntrospectionEncryptionAlgValuesSupported(), (String)"introspection_encryption_alg_values_supported");
        Util.putArray((JSONObject)jsonObj, (List)this.appConfiguration.getIntrospectionEncryptionEncValuesSupported(), (String)"introspection_encryption_enc_values_supported");
        Util.putArray((JSONObject)jsonObj, (List)this.appConfiguration.getLogoutStatusJwtSigningAlgValuesSupported(), (String)"logout_status_jwt_signing_alg_values_supported");
        Util.putArray((JSONObject)jsonObj, (List)this.appConfiguration.getTxTokenSigningAlgValuesSupported(), (String)"tx_token_signing_alg_values_supported");
        Util.putArray((JSONObject)jsonObj, (List)this.appConfiguration.getTxTokenEncryptionAlgValuesSupported(), (String)"tx_token_encryption_alg_values_supported");
        Util.putArray((JSONObject)jsonObj, (List)this.appConfiguration.getTxTokenEncryptionEncValuesSupported(), (String)"tx_token_encryption_enc_values_supported");
        Util.putArray((JSONObject)jsonObj, (List)this.appConfiguration.getIdTokenSigningAlgValuesSupported(), (String)"id_token_signing_alg_values_supported");
        Util.putArray((JSONObject)jsonObj, (List)this.appConfiguration.getIdTokenEncryptionAlgValuesSupported(), (String)"id_token_encryption_alg_values_supported");
        Util.putArray((JSONObject)jsonObj, (List)this.appConfiguration.getIdTokenEncryptionEncValuesSupported(), (String)"id_token_encryption_enc_values_supported");
        Util.putArray((JSONObject)jsonObj, (List)this.appConfiguration.getAccessTokenSigningAlgValuesSupported(), (String)"access_token_signing_alg_values_supported");
        Util.putArray((JSONObject)jsonObj, (List)this.appConfiguration.getRequestObjectSigningAlgValuesSupported(), (String)"request_object_signing_alg_values_supported");
        Util.putArray((JSONObject)jsonObj, (List)this.appConfiguration.getRequestObjectEncryptionAlgValuesSupported(), (String)"request_object_encryption_alg_values_supported");
        Util.putArray((JSONObject)jsonObj, (List)this.appConfiguration.getRequestObjectEncryptionEncValuesSupported(), (String)"request_object_encryption_enc_values_supported");
        Util.putArray((JSONObject)jsonObj, (List)this.appConfiguration.getTokenEndpointAuthMethodsSupported(), (String)"token_endpoint_auth_methods_supported");
        Util.putArray((JSONObject)jsonObj, (List)this.appConfiguration.getTokenEndpointAuthSigningAlgValuesSupported(), (String)"token_endpoint_auth_signing_alg_values_supported");
        Util.putArray((JSONObject)jsonObj, (List)this.appConfiguration.getDpopSigningAlgValuesSupported(), (String)"dpop_signing_alg_values_supported");
        Util.putArray((JSONObject)jsonObj, (List)this.appConfiguration.getDisplayValuesSupported(), (String)"display_values_supported");
        Util.putArray((JSONObject)jsonObj, (List)this.appConfiguration.getClaimTypesSupported(), (String)"claim_types_supported");
        jsonObj.put("service_documentation", (Object)this.appConfiguration.getServiceDocumentation());
        Util.putArray((JSONObject)jsonObj, (List)this.appConfiguration.getIdTokenTokenBindingCnfValuesSupported(), (String)"id_token_token_binding_cnf_values_supported");
        Util.putArray((JSONObject)jsonObj, (List)this.appConfiguration.getClaimsLocalesSupported(), (String)"claims_locales_supported");
        Util.putArray((JSONObject)jsonObj, (List)this.appConfiguration.getUiLocalesSupported(), (String)"ui_locales_supported");
        JSONArray scopesSupported = new JSONArray();
        JSONArray claimsSupported = new JSONArray();
        JSONArray scopeToClaimsMapping = this.createScopeToClaimsMapping(scopesSupported, claimsSupported);
        if (scopesSupported.length() > 0) {
            jsonObj.put("scopes_supported", (Object)scopesSupported);
        }
        if (claimsSupported.length() > 0) {
            jsonObj.put("claims_supported", (Object)claimsSupported);
        }
        jsonObj.put("scope_to_claims_mapping", (Object)scopeToClaimsMapping);
        jsonObj.put("claims_parameter_supported", (Object)this.appConfiguration.getClaimsParameterSupported());
        jsonObj.put("request_parameter_supported", (Object)this.appConfiguration.getRequestParameterSupported());
        jsonObj.put("request_uri_parameter_supported", (Object)this.appConfiguration.getRequestUriParameterSupported());
        jsonObj.put("require_request_uri_registration", (Object)this.appConfiguration.getRequireRequestUriRegistration());
        jsonObj.put("op_policy_uri", (Object)this.appConfiguration.getOpPolicyUri());
        jsonObj.put("op_tos_uri", (Object)this.appConfiguration.getOpTosUri());
        jsonObj.put("tls_client_certificate_bound_access_tokens", (Object)Boolean.TRUE);
        jsonObj.put("backchannel_logout_supported", isEndSessionEnabled);
        jsonObj.put("backchannel_logout_session_supported", isEndSessionEnabled);
        jsonObj.put("frontchannel_logout_supported", isEndSessionEnabled);
        jsonObj.put("frontchannel_logout_session_supported", isEndSessionEnabled);
        jsonObj.put("frontchannel_logout_session_supported", this.appConfiguration.getFrontChannelLogoutSessionSupported() != false && isEndSessionEnabled);
        this.addMtlsAliases(jsonObj);
        this.cibaConfigurationService.processConfiguration(jsonObj);
        if (this.appConfiguration.isFeatureEnabled(FeatureFlagType.SSA) && this.appConfiguration.getSsaConfiguration() != null) {
            jsonObj.put("ssa_endpoint", (Object)this.appConfiguration.getSsaConfiguration().getSsaEndpoint());
        }
        if ((acrMappings = this.appConfiguration.getAcrMappings()) != null && !acrMappings.isEmpty()) {
            jsonObj.put("acr_mappings", acrMappings);
        }
        OpenIdConfiguration.filterOutKeys(jsonObj, this.appConfiguration);
        this.localResponseCache.putDiscoveryResponse(jsonObj);
        return jsonObj;
    }

    public String endpointUrl(String path) {
        return DiscoveryService.endpointUrl(this.appConfiguration.getEndSessionEndpoint(), path);
    }

    public static String endpointUrl(String endSessionEndpoint, String path) {
        return org.apache.commons.lang3.StringUtils.replace((String)endSessionEndpoint, (String)"/end_session", (String)path);
    }

    public String getStatusListEndpoint() {
        return this.endpointUrl("/status_list");
    }

    public String getStatusListAggregationEndpoint() {
        return this.endpointUrl("/status_list_aggregation");
    }

    public static String getAccessEvaluationV1Endpoint(AppConfiguration appConfiguration) {
        return DiscoveryService.endpointUrl(appConfiguration.getEndSessionEndpoint(), "/access/v1/evaluation");
    }

    @Deprecated
    private JSONObject createAuthLevelMapping() {
        JSONObject mappings = new JSONObject();
        try {
            Map<Integer, Set<String>> map = this.externalAuthenticationService.levelToAcrMapping();
            for (Map.Entry<Integer, Set<String>> entry : map.entrySet()) {
                mappings.put(entry.getKey().toString(), (Collection)entry.getValue());
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return mappings;
    }

    public List<String> getAcrValuesList() {
        return DiscoveryService.getAcrValuesList(this.externalAuthenticationService.getAcrValuesList());
    }

    public static List<String> getAcrValuesList(List<String> scriptAliases) {
        if (!scriptAliases.contains("simple_password_auth")) {
            scriptAliases.add("simple_password_auth");
        }
        return scriptAliases;
    }

    private boolean canShowInConfigEndpoint(ScopeAttributes scopeAttributes) {
        return scopeAttributes.isShowInConfigurationEndpoint();
    }

    private void addMtlsAliases(JSONObject jsonObj) {
        JSONObject aliases = new JSONObject();
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.appConfiguration.getMtlsAuthorizationEndpoint())) {
            aliases.put("authorization_endpoint", (Object)this.appConfiguration.getMtlsAuthorizationEndpoint());
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.appConfiguration.getMtlsAuthorizationChallengeEndpoint())) {
            aliases.put("authorization_challenge_endpoint", (Object)this.appConfiguration.getMtlsAuthorizationChallengeEndpoint());
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.appConfiguration.getMtlsTokenEndpoint())) {
            aliases.put("token_endpoint", (Object)this.appConfiguration.getMtlsTokenEndpoint());
        }
        if (this.appConfiguration.isFeatureEnabled(FeatureFlagType.STATUS_LIST) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.appConfiguration.getMtlsEndSessionEndpoint())) {
            aliases.put("status_list_endpoint", (Object)DiscoveryService.endpointUrl(this.appConfiguration.getMtlsEndSessionEndpoint(), "/status_list"));
            aliases.put("status_list_aggregation_endpoint", (Object)DiscoveryService.endpointUrl(this.appConfiguration.getMtlsEndSessionEndpoint(), "/status_list_aggregation"));
        }
        if (this.appConfiguration.isFeatureEnabled(FeatureFlagType.ACCESS_EVALUATION) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.appConfiguration.getMtlsEndSessionEndpoint())) {
            aliases.put("access_evaluation_v1_endpoint", (Object)DiscoveryService.endpointUrl(this.appConfiguration.getMtlsEndSessionEndpoint(), "/access/v1/evaluation"));
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.appConfiguration.getMtlsJwksUri())) {
            aliases.put("jwks_uri", (Object)this.appConfiguration.getMtlsJwksUri());
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.appConfiguration.getMtlsCheckSessionIFrame())) {
            aliases.put("check_session_iframe", (Object)this.appConfiguration.getMtlsCheckSessionIFrame());
        }
        if (this.appConfiguration.isFeatureEnabled(FeatureFlagType.REVOKE_TOKEN) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.appConfiguration.getMtlsTokenRevocationEndpoint())) {
            aliases.put("revocation_endpoint", (Object)this.appConfiguration.getMtlsTokenRevocationEndpoint());
        }
        if (this.appConfiguration.isFeatureEnabled(FeatureFlagType.GLOBAL_TOKEN_REVOCATION) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.appConfiguration.getMtlsEndSessionEndpoint())) {
            aliases.put("global_token_revocation_endpoint", (Object)DiscoveryService.endpointUrl(this.appConfiguration.getMtlsEndSessionEndpoint(), "/global-token-revocation"));
        }
        if (this.appConfiguration.isFeatureEnabled(FeatureFlagType.USERINFO) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.appConfiguration.getMtlsUserInfoEndpoint())) {
            aliases.put("userinfo_endpoint", (Object)this.appConfiguration.getMtlsUserInfoEndpoint());
        }
        if (this.appConfiguration.isFeatureEnabled(FeatureFlagType.CLIENTINFO) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.appConfiguration.getMtlsClientInfoEndpoint())) {
            aliases.put("clientinfo_endpoint", (Object)this.appConfiguration.getMtlsClientInfoEndpoint());
        }
        if (this.appConfiguration.isFeatureEnabled(FeatureFlagType.END_SESSION) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.appConfiguration.getMtlsEndSessionEndpoint())) {
            aliases.put("end_session_endpoint", (Object)this.appConfiguration.getMtlsEndSessionEndpoint());
        }
        if (this.appConfiguration.isFeatureEnabled(FeatureFlagType.REGISTRATION) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.appConfiguration.getMtlsRegistrationEndpoint())) {
            aliases.put("registration_endpoint", (Object)this.appConfiguration.getMtlsRegistrationEndpoint());
        }
        if (this.appConfiguration.isFeatureEnabled(FeatureFlagType.ID_GENERATION) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.appConfiguration.getMtlsIdGenerationEndpoint())) {
            aliases.put("id_generation_endpoint", (Object)this.appConfiguration.getMtlsIdGenerationEndpoint());
        }
        if (this.appConfiguration.isFeatureEnabled(FeatureFlagType.INTROSPECTION) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.appConfiguration.getMtlsIntrospectionEndpoint())) {
            aliases.put("introspection_endpoint", (Object)this.appConfiguration.getMtlsIntrospectionEndpoint());
        }
        if (this.appConfiguration.isFeatureEnabled(FeatureFlagType.DEVICE_AUTHZ) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.appConfiguration.getMtlsDeviceAuthzEndpoint())) {
            aliases.put("device_authorization_endpoint", (Object)this.appConfiguration.getMtlsDeviceAuthzEndpoint());
        }
        if (this.appConfiguration.isFeatureEnabled(FeatureFlagType.PAR) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.appConfiguration.getMtlsParEndpoint())) {
            aliases.put("pushed_authorization_request_endpoint", (Object)this.appConfiguration.getMtlsParEndpoint());
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("MTLS aliases: {}", (Object)aliases);
        }
        if (!aliases.isEmpty()) {
            jsonObj.put("mtls_endpoint_aliases", (Object)aliases);
        }
    }

    @Deprecated
    private JSONArray createScopeToClaimsMapping(JSONArray scopesSupported, JSONArray claimsSupported) {
        JSONArray scopeToClaimMapping = new JSONArray();
        HashSet<String> scopes = new HashSet<String>();
        HashSet<String> claims = new HashSet<String>();
        try {
            for (Scope scope : this.scopeService.getAllScopesList()) {
                if (scope.getScopeType() == ScopeType.SPONTANEOUS && scope.isDeletable().booleanValue() || !this.canShowInConfigEndpoint(scope.getAttributes())) continue;
                JSONArray claimsList = new JSONArray();
                JSONObject mapping = new JSONObject();
                mapping.put(scope.getId(), (Object)claimsList);
                scopes.add(scope.getId());
                scopeToClaimMapping.put((Object)mapping);
                if (ScopeType.DYNAMIC.equals((Object)scope.getScopeType())) {
                    List<String> claimNames = this.externalDynamicScopeService.executeExternalGetSupportedClaimsMethods(Arrays.asList(scope));
                    for (String claimName : claimNames) {
                        if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)claimName)) continue;
                        claimsList.put((Object)claimName);
                        claims.add(claimName);
                    }
                    continue;
                }
                List claimIdList = scope.getClaims();
                if (claimIdList == null || claimIdList.isEmpty()) continue;
                for (String claimDn : claimIdList) {
                    JansAttribute attribute = this.attributeService.getAttributeByDn(claimDn);
                    String claimName = attribute.getClaimName();
                    if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)claimName) || Boolean.TRUE.equals(attribute.getJansHideOnDiscovery())) continue;
                    claimsList.put((Object)claimName);
                    claims.add(claimName);
                }
            }
            for (String string : scopes) {
                scopesSupported.put((Object)string);
            }
            for (String string : claims) {
                claimsSupported.put((Object)string);
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return scopeToClaimMapping;
    }
}

