/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.service;

import io.jans.as.common.model.common.User;
import io.jans.as.common.model.registration.Client;
import io.jans.as.model.common.BackchannelTokenDeliveryMode;
import io.jans.as.model.common.SubjectType;
import io.jans.as.model.config.StaticConfiguration;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.persistence.model.PairwiseIdentifier;
import io.jans.as.persistence.model.SectorIdentifier;
import io.jans.as.server.model.common.CIBAGrant;
import io.jans.as.server.model.common.IAuthorizationGrant;
import io.jans.as.server.service.PairwiseIdentifierService;
import io.jans.orm.PersistenceEntryManager;
import io.jans.util.StringHelper;
import jakarta.ejb.Stateless;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.net.URI;
import java.util.UUID;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

@Stateless
@Named
public class SectorIdentifierService {
    @Inject
    private Logger log;
    @Inject
    private PersistenceEntryManager ldapEntryManager;
    @Inject
    private StaticConfiguration staticConfiguration;
    @Inject
    private PairwiseIdentifierService pairwiseIdentifierService;
    @Inject
    protected AppConfiguration appConfiguration;

    public SectorIdentifier getSectorIdentifierById(String jsId) {
        SectorIdentifier result = null;
        try {
            result = (SectorIdentifier)this.ldapEntryManager.find(SectorIdentifier.class, (Object)this.getDnForSectorIdentifier(jsId));
        }
        catch (Exception e) {
            this.log.error("Failed to find sector identifier by jsId " + jsId, (Throwable)e);
        }
        return result;
    }

    public String getDnForSectorIdentifier(String jsId) {
        String sectorIdentifierDn = this.staticConfiguration.getBaseDn().getSectorIdentifiers();
        if (StringHelper.isEmpty((String)jsId)) {
            return sectorIdentifierDn;
        }
        return String.format("jansId=%s,%s", jsId, sectorIdentifierDn);
    }

    public String getSub(IAuthorizationGrant grant) {
        Client client = grant.getClient();
        User user = grant.getUser();
        if (user == null) {
            this.log.trace("User is null, return blank sub");
            return "";
        }
        if (client == null) {
            this.log.trace("Client is null, return blank sub.");
            return "";
        }
        return this.getSub(client, user, grant instanceof CIBAGrant);
    }

    public String getSub(Client client, User user, boolean isCibaGrant) {
        if (user == null) {
            this.log.trace("User is null, return blank sub");
            return "";
        }
        if (client == null) {
            this.log.trace("Client is null, return blank sub.");
            return "";
        }
        String openidSubValue = this.getOpenidSubValue(client, user);
        boolean isClientPairwise = SubjectType.PAIRWISE.equals((Object)client.getSubjectType());
        if (isClientPairwise) {
            String sectorIdentifierUri = StringUtils.isNotBlank((CharSequence)client.getSectorIdentifierUri()) ? client.getSectorIdentifierUri() : (!isCibaGrant ? (!ArrayUtils.isEmpty((Object[])client.getRedirectUris()) ? client.getRedirectUris()[0] : null) : (client.getBackchannelTokenDeliveryMode() == BackchannelTokenDeliveryMode.PUSH ? client.getBackchannelClientNotificationEndpoint() : client.getJwksUri()));
            String userInum = user.getAttribute("inum");
            try {
                if (StringUtils.isNotBlank((CharSequence)sectorIdentifierUri)) {
                    String sectorIdentifier = URI.create(sectorIdentifierUri).getHost();
                    PairwiseIdentifier pairwiseIdentifier = this.pairwiseIdentifierService.findPairWiseIdentifier(userInum, sectorIdentifier, client.getClientId(), openidSubValue);
                    if (pairwiseIdentifier == null) {
                        pairwiseIdentifier = new PairwiseIdentifier(sectorIdentifier, client.getClientId(), userInum);
                        pairwiseIdentifier.setId(UUID.randomUUID().toString());
                        pairwiseIdentifier.setDn(this.pairwiseIdentifierService.getDnForPairwiseIdentifier(pairwiseIdentifier.getId(), userInum));
                        this.pairwiseIdentifierService.addPairwiseIdentifier(userInum, pairwiseIdentifier);
                    }
                    return pairwiseIdentifier.getId();
                }
                this.log.trace("Sector identifier uri is blank for client: {}", (Object)client.getClientId());
            }
            catch (Exception e) {
                this.log.error("Failed to get sub claim. PairwiseIdentifierService failed to find pair wise identifier.", (Throwable)e);
                return "";
            }
        }
        return openidSubValue;
    }

    private String getOpenidSubValue(Client client, User user) {
        String openidSubAttribute = this.appConfiguration.getOpenidSubAttribute();
        if (Boolean.TRUE.equals(this.appConfiguration.getPublicSubjectIdentifierPerClientEnabled()) && StringUtils.isNotBlank((CharSequence)client.getAttributes().getPublicSubjectIdentifierAttribute())) {
            openidSubAttribute = client.getAttributes().getPublicSubjectIdentifierAttribute();
        }
        if (StringHelper.equalsIgnoreCase((String)openidSubAttribute, (String)"uid")) {
            return user.getUserId();
        }
        return user.getAttribute(openidSubAttribute);
    }
}

