/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.service;

import io.jans.as.server.model.ldap.UserGroup;
import io.jans.orm.PersistenceEntryManager;
import io.jans.orm.exception.EntryPersistenceException;
import io.jans.orm.search.filter.Filter;
import jakarta.ejb.Stateless;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

@Stateless
@Named
public class UserGroupService {
    @Inject
    private Logger log;
    @Inject
    private PersistenceEntryManager ldapEntryManager;

    public UserGroup loadGroup(String groupDN) {
        try {
            if (StringUtils.isNotBlank((CharSequence)groupDN)) {
                return (UserGroup)this.ldapEntryManager.find(UserGroup.class, (Object)groupDN);
            }
        }
        catch (Exception e) {
            this.log.debug(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public boolean isUserInGroup(String groupDN, String userDN) {
        String[] member;
        UserGroup group = this.loadGroup(groupDN);
        if (group != null && (member = group.getMember()) != null) {
            return Arrays.asList(member).contains(userDN);
        }
        return false;
    }

    public boolean isUserInGroupOrMember(String groupDn, String personDn) {
        Filter ownerFilter = Filter.createEqualityFilter((String)"owner", (Object)personDn);
        Filter memberFilter = Filter.createEqualityFilter((String)"member", (Object)personDn);
        Filter searchFilter = Filter.createORFilter((Filter[])new Filter[]{ownerFilter, memberFilter});
        try {
            return !this.ldapEntryManager.findEntries(groupDn, UserGroup.class, searchFilter, 1).isEmpty();
        }
        catch (EntryPersistenceException ex) {
            this.log.error("Failed to determine if person '{}' memeber or owner of group '{}'", new Object[]{personDn, groupDn, ex});
            return false;
        }
    }

    public boolean isInAnyGroup(String[] groupDNs, String userDN) {
        return groupDNs != null && this.isInAnyGroup(Arrays.asList(groupDNs), userDN);
    }

    public boolean isInAnyGroup(List<String> groupDNs, String userDN) {
        if (groupDNs != null && !groupDNs.isEmpty() && userDN != null && !userDN.isEmpty()) {
            for (String groupDN : groupDNs) {
                if (!this.isUserInGroup(groupDN, userDN)) continue;
                return true;
            }
        }
        return false;
    }
}

