/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.service.ciba;

import io.jans.as.common.model.registration.Client;
import io.jans.as.model.common.GrantType;
import io.jans.as.model.config.StaticConfiguration;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.server.model.common.CibaRequestCacheControl;
import io.jans.as.server.model.common.CibaRequestStatus;
import io.jans.as.server.model.ldap.CIBARequest;
import io.jans.orm.PersistenceEntryManager;
import io.jans.orm.search.filter.Filter;
import io.jans.service.CacheService;
import jakarta.ejb.Stateless;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;

@Stateless
@Named
public class CibaRequestService {
    @Inject
    private Logger log;
    @Inject
    private PersistenceEntryManager entryManager;
    @Inject
    private StaticConfiguration staticConfiguration;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private CacheService cacheService;

    private String cibaBaseDn() {
        return this.staticConfiguration.getBaseDn().getCiba();
    }

    public void persistRequest(CibaRequestCacheControl request, int expiresIn) {
        Date expirationDate = DateUtils.addSeconds((Date)new Date(), (int)expiresIn);
        String authReqId = request.getAuthReqId();
        CIBARequest cibaRequest = new CIBARequest();
        cibaRequest.setDn("authReqId=" + authReqId + "," + this.cibaBaseDn());
        cibaRequest.setAuthReqId(authReqId);
        cibaRequest.setClientId(request.getClient().getClientId());
        cibaRequest.setExpirationDate(expirationDate);
        cibaRequest.setCreationDate(new Date());
        cibaRequest.setStatus(CibaRequestStatus.PENDING.getValue());
        cibaRequest.setUserId(request.getUser().getUserId());
        this.entryManager.persist((Object)cibaRequest);
    }

    public CIBARequest load(String authReqId) {
        try {
            return (CIBARequest)this.entryManager.find(CIBARequest.class, (Object)authReqId);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public List<CIBARequest> loadExpiredByStatus(CibaRequestStatus authorizationStatus, int maxRequestsToGet) {
        try {
            Date now = new Date();
            Filter filter = Filter.createANDFilter((Filter[])new Filter[]{Filter.createEqualityFilter((String)"jansStatus", (Object)authorizationStatus.getValue()), Filter.createLessOrEqualFilter((String)"exp", (Object)this.entryManager.encodeTime(this.cibaBaseDn(), now))});
            return this.entryManager.findEntries(this.cibaBaseDn(), CIBARequest.class, filter, maxRequestsToGet);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public void updateStatus(CIBARequest cibaRequest, CibaRequestStatus authorizationStatus) {
        try {
            cibaRequest.setStatus(authorizationStatus.getValue());
            this.entryManager.merge((Object)cibaRequest);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void removeCibaRequest(CIBARequest cibaRequest) {
        try {
            this.entryManager.remove((Object)cibaRequest);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void removeCibaRequest(String authReqId) {
        try {
            String requestDn = String.format("authReqId=%s,%s", authReqId, this.cibaBaseDn());
            this.entryManager.remove(requestDn);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void save(CibaRequestCacheControl request, int expiresIn) {
        int expiresInCache = expiresIn;
        if (this.appConfiguration.getCibaGrantLifeExtraTimeSec() > 0) {
            expiresInCache += this.appConfiguration.getCibaGrantLifeExtraTimeSec();
        }
        this.cacheService.put(expiresInCache, request.cacheKey(), (Object)request);
        this.persistRequest(request, expiresIn);
        this.log.trace("Ciba request saved in cache, authReqId: {} clientId: {}", (Object)request.getAuthReqId(), (Object)request.getClient().getClientId());
    }

    public void update(CibaRequestCacheControl request) {
        int expiresInCache = request.getExpiresIn();
        if (this.appConfiguration.getCibaGrantLifeExtraTimeSec() > 0) {
            expiresInCache += this.appConfiguration.getCibaGrantLifeExtraTimeSec();
        }
        this.cacheService.put(expiresInCache, request.cacheKey(), (Object)request);
    }

    public CibaRequestCacheControl getCibaRequest(String authReqId) {
        Object cachedObject = this.cacheService.get(authReqId);
        if (cachedObject == null) {
            cachedObject = this.cacheService.get(authReqId);
            this.log.trace("Failed to fetch CIBA request from cache, authReqId: {}", (Object)authReqId);
        }
        return cachedObject instanceof CibaRequestCacheControl ? (CibaRequestCacheControl)cachedObject : null;
    }

    public void removeCibaCacheRequest(String cacheKey) {
        try {
            this.cacheService.remove(cacheKey);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }

    public boolean hasCibaCompatibility(Client client) {
        if (client.getBackchannelTokenDeliveryMode() == null) {
            return false;
        }
        for (GrantType gt : client.getGrantTypes()) {
            if (!gt.getValue().equals(GrantType.CIBA.getValue())) continue;
            return true;
        }
        return false;
    }
}

