/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.service.expiration;

import io.jans.as.common.model.session.SessionId;
import io.jans.as.model.config.StaticConfiguration;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.server.service.cdi.event.ExpirationEvent;
import io.jans.as.server.service.expiration.ExpId;
import io.jans.as.server.service.expiration.ExpType;
import io.jans.as.server.service.external.ExternalApplicationSessionService;
import io.jans.as.server.service.external.session.SessionEvent;
import io.jans.as.server.service.external.session.SessionEventType;
import io.jans.orm.PersistenceEntryManager;
import io.jans.orm.search.filter.Filter;
import io.jans.service.cdi.async.Asynchronous;
import io.jans.service.cdi.event.Scheduled;
import io.jans.service.timer.event.TimerEvent;
import io.jans.service.timer.schedule.TimerSchedule;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Event;
import jakarta.enterprise.event.Observes;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.lang.annotation.Annotation;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import net.jodah.expiringmap.ExpirationListener;
import net.jodah.expiringmap.ExpirationPolicy;
import net.jodah.expiringmap.ExpiringMap;
import org.slf4j.Logger;

@ApplicationScoped
@Named
public class ExpirationNotificatorTimer
implements ExpirationListener<ExpId, Object> {
    private static final int DEFAULT_INTERVAL = 600;
    @Inject
    private Logger log;
    @Inject
    private Event<TimerEvent> timerEvent;
    @Inject
    private PersistenceEntryManager persistenceEntryManager;
    @Inject
    private StaticConfiguration staticConfiguration;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private ExternalApplicationSessionService externalApplicationSessionService;
    private ExpiringMap<ExpId, Object> expiringMap = ExpiringMap.builder().expirationPolicy(ExpirationPolicy.CREATED).variableExpiration().build();
    private AtomicBoolean isActive;
    private long lastFinishedTime;

    public void initTimer() {
        this.log.debug("Initializing ExpirationNotificatorTimer");
        this.isActive = new AtomicBoolean(false);
        this.expiringMap = ExpiringMap.builder().expirationPolicy(ExpirationPolicy.CREATED).maxSize(this.appConfiguration.getExpirationNotificatorMapSizeLimit()).variableExpiration().build();
        this.expiringMap.addExpirationListener((ExpirationListener)this);
        this.timerEvent.fire((Object)new TimerEvent(new TimerSchedule(600, 600), (Object)new ExpirationEvent(), new Annotation[]{Scheduled.Literal.INSTANCE}));
        this.lastFinishedTime = System.currentTimeMillis();
    }

    @Asynchronous
    public void process(@Observes @Scheduled ExpirationEvent expirationEvent) {
        if (!this.appConfiguration.getExpirationNotificatorEnabled().booleanValue()) {
            return;
        }
        if (this.isActive.get()) {
            return;
        }
        if (!this.isActive.compareAndSet(false, true)) {
            return;
        }
        try {
            if (!this.allowToRun()) {
                this.log.trace("Not allowed to run.");
                return;
            }
            this.fillMap();
            this.lastFinishedTime = System.currentTimeMillis();
        }
        catch (Exception ex) {
            this.log.error("Exception happened while trying to fill expiringMap update", (Throwable)ex);
        }
        finally {
            this.isActive.set(false);
        }
    }

    private void fillMap() {
        Calendar future = Calendar.getInstance();
        future.add(13, this.appConfiguration.getExpirationNotificatorIntervalInSeconds());
        this.fillSessions(future.getTime());
    }

    private void fillSessions(Date future) {
        Filter filter;
        String baseDn = this.staticConfiguration.getBaseDn().getSessions();
        List sessions = this.persistenceEntryManager.findEntries(baseDn, SessionId.class, filter = Filter.createANDFilter((Filter[])new Filter[]{Filter.createEqualityFilter((String)"del", (Object)true), Filter.createLessOrEqualFilter((String)"exp", (Object)this.persistenceEntryManager.encodeTime(baseDn, future))}));
        if (sessions == null || sessions.isEmpty()) {
            return;
        }
        long now = new Date().getTime();
        for (SessionId session : sessions) {
            long duration = session.getExpirationDate().getTime() - now;
            if (duration <= 0L) {
                this.remove(session);
                continue;
            }
            this.expiringMap.put((Object)new ExpId(session.getId(), ExpType.SESSION), (Object)session, duration, TimeUnit.MILLISECONDS);
        }
    }

    public void expired(ExpId key, Object value) {
        if (key.getType() == ExpType.SESSION && value instanceof SessionId) {
            this.externalApplicationSessionService.externalEvent(new SessionEvent(SessionEventType.GONE, (SessionId)value));
        }
    }

    private boolean allowToRun() {
        int interval = this.appConfiguration.getExpirationNotificatorIntervalInSeconds();
        if (interval < 0) {
            this.log.info("ExpirationNotificator Timer is disabled.");
            this.log.warn("ExpirationNotificator Timer Interval (expirationNotificatorIntervalInSeconds in oxauth configuration) is negative which turns OFF internal clean up by the server. Please set it to positive value if you wish internal clean up timer run.");
            return false;
        }
        long timerInterval = (long)interval * 1000L;
        long timeDiffrence = System.currentTimeMillis() - this.lastFinishedTime;
        return timeDiffrence >= timerInterval;
    }

    public boolean remove(SessionId sessionId) {
        try {
            this.persistenceEntryManager.remove(sessionId.getDn());
            this.externalApplicationSessionService.externalEvent(new SessionEvent(SessionEventType.GONE, sessionId));
            return true;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }
}

