/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.service.external;

import io.jans.as.server.model.common.ExecutionContext;
import io.jans.model.custom.script.CustomScriptType;
import io.jans.model.custom.script.conf.CustomScriptConfiguration;
import io.jans.model.custom.script.type.authzen.AccessEvaluationDiscoveryType;
import io.jans.service.custom.script.ExternalScriptService;
import jakarta.enterprise.context.ApplicationScoped;
import org.json.JSONObject;

@ApplicationScoped
public class ExternalAccessEvaluationDiscoveryService
extends ExternalScriptService {
    public ExternalAccessEvaluationDiscoveryService() {
        super(CustomScriptType.ACCESS_EVALUATION_DISCOVERY);
    }

    public boolean modifyDiscovery(JSONObject jsonObject, ExecutionContext context) {
        CustomScriptConfiguration script = this.getDefaultExternalCustomScript();
        if (script == null) {
            this.log.debug("No access evaluation discovery script set.");
            return false;
        }
        try {
            this.log.debug("Executing python 'modifyDiscovery' method, script name: {}, jsonObj: {}, context: {}", new Object[]{script.getName(), jsonObject, context});
            context.setScript(script);
            AccessEvaluationDiscoveryType discoveryType = (AccessEvaluationDiscoveryType)script.getExternalType();
            boolean result = discoveryType.modifyResponse((Object)jsonObject, (Object)context);
            this.log.debug("Finished 'modifyDiscovery' method, script name: {}, jsonObj: {}, context: {}, result: {}", new Object[]{script.getName(), jsonObject, context, result});
            return result;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            this.saveScriptError(script.getCustomScript(), e);
            return false;
        }
    }
}

