/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.service.external;

import io.jans.as.server.service.external.context.ConsentGatheringContext;
import io.jans.model.custom.script.CustomScriptType;
import io.jans.model.custom.script.conf.CustomScriptConfiguration;
import io.jans.model.custom.script.type.authz.ConsentGatheringType;
import io.jans.service.LookupService;
import io.jans.service.custom.script.ExternalScriptService;
import io.jans.util.StringHelper;
import jakarta.ejb.DependsOn;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@ApplicationScoped
@DependsOn(value={"appInitializer"})
@Named
public class ExternalConsentGatheringService
extends ExternalScriptService {
    private static final long serialVersionUID = 1741073794567832914L;
    @Inject
    private LookupService lookupService;
    protected Map<String, CustomScriptConfiguration> scriptInumMap;

    public ExternalConsentGatheringService() {
        super(CustomScriptType.CONSENT_GATHERING);
    }

    protected void reloadExternal() {
        this.scriptInumMap = this.buildExternalConfigurationsInumMap(this.customScriptConfigurations);
    }

    private Map<String, CustomScriptConfiguration> buildExternalConfigurationsInumMap(List<CustomScriptConfiguration> customScriptConfigurations) {
        HashMap<String, CustomScriptConfiguration> reloadedExternalConfigurations = new HashMap<String, CustomScriptConfiguration>(customScriptConfigurations.size());
        for (CustomScriptConfiguration customScriptConfiguration : customScriptConfigurations) {
            reloadedExternalConfigurations.put(customScriptConfiguration.getInum(), customScriptConfiguration);
        }
        return reloadedExternalConfigurations;
    }

    public CustomScriptConfiguration getScriptByDn(String scriptDn) {
        String consentScriptInum = this.lookupService.getInumFromDn(scriptDn);
        return this.getScriptByInum(consentScriptInum);
    }

    public CustomScriptConfiguration getScriptByInum(String inum) {
        if (StringHelper.isEmpty((String)inum)) {
            return null;
        }
        return this.scriptInumMap.get(inum);
    }

    private ConsentGatheringType consentScript(CustomScriptConfiguration script) {
        return (ConsentGatheringType)script.getExternalType();
    }

    public boolean authorize(CustomScriptConfiguration script, int step, ConsentGatheringContext context) {
        try {
            this.log.trace("Executing python 'authorize' method, script: " + script.getName());
            boolean result = this.consentScript(script).authorize(step, (Object)context);
            this.log.trace("python 'authorize' result: " + result);
            return result;
        }
        catch (Exception ex) {
            this.log.error("Failed to execute python 'authorize' method, script: " + script.getName() + ", message: " + ex.getMessage(), (Throwable)ex);
            this.saveScriptError(script.getCustomScript(), ex);
            return false;
        }
    }

    public int getNextStep(CustomScriptConfiguration script, int step, ConsentGatheringContext context) {
        try {
            this.log.trace("Executing python 'getNextStep' method, script: " + script.getName());
            int result = this.consentScript(script).getNextStep(step, (Object)context);
            this.log.trace("python 'getNextStep' result: " + result);
            return result;
        }
        catch (Exception ex) {
            this.log.error("Failed to execute python 'getNextStep' method, script: " + script.getName() + ", message: " + ex.getMessage(), (Throwable)ex);
            this.saveScriptError(script.getCustomScript(), ex);
            return -1;
        }
    }

    public boolean prepareForStep(CustomScriptConfiguration script, int step, ConsentGatheringContext context) {
        try {
            this.log.trace("Executing python 'prepareForStep' method, script: " + script.getName());
            boolean result = this.consentScript(script).prepareForStep(step, (Object)context);
            this.log.trace("python 'prepareForStep' result: " + result);
            return result;
        }
        catch (Exception ex) {
            this.log.error("Failed to execute python 'prepareForStep' method, script: " + script.getName() + ", message: " + ex.getMessage(), (Throwable)ex);
            this.saveScriptError(script.getCustomScript(), ex);
            return false;
        }
    }

    public int getStepsCount(CustomScriptConfiguration script, ConsentGatheringContext context) {
        try {
            this.log.trace("Executing python 'getStepsCount' method, script: " + script.getName());
            int result = this.consentScript(script).getStepsCount((Object)context);
            this.log.trace("python 'getStepsCount' result: " + result);
            return result;
        }
        catch (Exception ex) {
            this.log.error("Failed to execute python 'getStepsCount' method, script: " + script.getName() + ", message: " + ex.getMessage(), (Throwable)ex);
            this.saveScriptError(script.getCustomScript(), ex);
            return -1;
        }
    }

    public String getPageForStep(CustomScriptConfiguration script, int step, ConsentGatheringContext context) {
        try {
            this.log.trace("Executing python 'getPageForStep' method, script: " + script.getName());
            String result = this.consentScript(script).getPageForStep(step, (Object)context);
            this.log.trace("python 'getPageForStep' result: " + result);
            return result;
        }
        catch (Exception ex) {
            this.log.error("Failed to execute python 'getPageForStep' method, script: " + script.getName() + ", message: " + ex.getMessage(), (Throwable)ex);
            this.saveScriptError(script.getCustomScript(), ex);
            return "";
        }
    }
}

