/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.service.external;

import com.google.common.collect.Sets;
import io.jans.as.common.model.registration.Client;
import io.jans.as.server.service.external.context.SpontaneousScopeExternalContext;
import io.jans.model.custom.script.CustomScriptType;
import io.jans.model.custom.script.conf.CustomScriptConfiguration;
import io.jans.model.custom.script.type.spontaneous.SpontaneousScopeType;
import io.jans.service.custom.script.ExternalScriptService;
import jakarta.ejb.DependsOn;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Named;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@ApplicationScoped
@DependsOn(value={"appInitializer"})
@Named
public class ExternalSpontaneousScopeService
extends ExternalScriptService {
    public ExternalSpontaneousScopeService() {
        super(CustomScriptType.SPONTANEOUS_SCOPE);
    }

    public void executeExternalManipulateScope(SpontaneousScopeExternalContext context) {
        for (CustomScriptConfiguration script : this.getScriptsToExecute(context.getClient())) {
            this.executeExternalManipulateScope(script, context);
            this.log.debug("GrantedScopes {} after execution of interception script {}.", context.getGrantedScopes(), (Object)script.getName());
        }
    }

    private void executeExternalManipulateScope(CustomScriptConfiguration scriptConfiguration, SpontaneousScopeExternalContext context) {
        try {
            this.log.debug("Executing external 'executeExternalManipulateScope' method, script name: {}, grantedScopes: {} , context: {}", new Object[]{scriptConfiguration.getName(), context.getGrantedScopes(), context});
            SpontaneousScopeType script = (SpontaneousScopeType)scriptConfiguration.getExternalType();
            script.manipulateScopes((Object)context);
            this.log.debug("Finished external 'executeExternalManipulateScope' method, script name: {}, grantedScopes: {} , context: {}", new Object[]{scriptConfiguration.getName(), context.getGrantedScopes(), context});
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            this.saveScriptError(scriptConfiguration.getCustomScript(), ex);
        }
    }

    private Set<CustomScriptConfiguration> getScriptsToExecute(Client client) {
        HashSet result = Sets.newHashSet();
        if (this.customScriptConfigurations == null) {
            return result;
        }
        List scriptDns = client.getAttributes().getSpontaneousScopeScriptDns();
        for (CustomScriptConfiguration script : this.customScriptConfigurations) {
            if (!scriptDns.contains(script.getCustomScript().getDn())) continue;
            result.add(script);
        }
        return result;
    }
}

