/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.service.external;

import io.jans.as.common.model.registration.Client;
import io.jans.as.server.model.common.ExecutionContext;
import io.jans.as.server.service.external.context.ExternalScriptContext;
import io.jans.model.custom.script.CustomScriptType;
import io.jans.model.custom.script.conf.CustomScriptConfiguration;
import io.jans.model.custom.script.type.token.ScriptTokenExchangeControl;
import io.jans.model.custom.script.type.token.TokenExchangeType;
import io.jans.service.custom.script.ExternalScriptService;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.ws.rs.WebApplicationException;
import java.util.List;
import org.json.JSONObject;

@ApplicationScoped
public class ExternalTokenExchangeService
extends ExternalScriptService {
    public ExternalTokenExchangeService() {
        super(CustomScriptType.TOKEN_EXCHANGE);
    }

    public ScriptTokenExchangeControl externalValidate(ExecutionContext context) {
        Client client = context.getClient();
        List scripts = this.getCustomScriptConfigurationsByDns(client.getAttributes().getPostAuthnScripts());
        if (scripts.isEmpty()) {
            return ScriptTokenExchangeControl.fail();
        }
        this.log.trace("Found {} token-exchange scripts.", (Object)scripts.size());
        for (CustomScriptConfiguration script : scripts) {
            ScriptTokenExchangeControl control = this.externalValidate(script, context);
            if (control == null) continue;
            return control;
        }
        return null;
    }

    public ScriptTokenExchangeControl externalValidate(CustomScriptConfiguration script, ExecutionContext context) {
        Client client = context.getClient();
        this.log.trace("Executing external 'validate' method, script name: {}, clientId: {}", (Object)script.getName(), (Object)client.getClientId());
        ScriptTokenExchangeControl result = null;
        try {
            ExternalScriptContext scriptContext = new ExternalScriptContext(context);
            TokenExchangeType tokenExchangeType = (TokenExchangeType)script.getExternalType();
            result = tokenExchangeType.validate((Object)scriptContext);
            scriptContext.throwWebApplicationExceptionIfSet();
        }
        catch (WebApplicationException e) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("WebApplicationException from script", (Throwable)e);
            }
            throw e;
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            this.saveScriptError(script.getCustomScript(), ex);
        }
        this.log.trace("Finished 'validate' method, script name: {}, clientId: {}, result: {}", new Object[]{script.getName(), client.getClientId(), result});
        return result;
    }

    public boolean externalModifyResponse(JSONObject response, ExecutionContext context) {
        Client client = context.getClient();
        List scripts = this.getCustomScriptConfigurationsByDns(client.getAttributes().getPostAuthnScripts());
        if (scripts.isEmpty()) {
            return false;
        }
        this.log.trace("Found {} token-exchange scripts.", (Object)scripts.size());
        for (CustomScriptConfiguration script : scripts) {
            if (this.externalModifyResponse(response, script, context)) continue;
            return false;
        }
        return true;
    }

    public boolean externalModifyResponse(JSONObject response, CustomScriptConfiguration script, ExecutionContext context) {
        Client client = context.getClient();
        this.log.debug("Executing external 'modifyResponse' method, script name: {}, clientId: {}, response: {}", new Object[]{script.getName(), client.getClientId(), response});
        boolean result = false;
        try {
            ExternalScriptContext scriptContext = new ExternalScriptContext(context);
            TokenExchangeType tokenExchangeType = (TokenExchangeType)script.getExternalType();
            result = tokenExchangeType.modifyResponse((Object)response, (Object)scriptContext);
            scriptContext.throwWebApplicationExceptionIfSet();
        }
        catch (WebApplicationException e) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("WebApplicationException from script", (Throwable)e);
            }
            throw e;
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            this.saveScriptError(script.getCustomScript(), ex);
        }
        this.log.debug("Finished 'modifyResponse' method, script name: {}, clientId: {}, result: {}, response: {}", new Object[]{script.getName(), client.getClientId(), result, response});
        return result;
    }
}

