/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.service.external;

import com.google.common.collect.Lists;
import io.jans.as.model.token.JsonWebResponse;
import io.jans.as.server.model.common.ExecutionContext;
import io.jans.as.server.service.external.context.ExternalScriptContext;
import io.jans.model.custom.script.CustomScriptType;
import io.jans.model.custom.script.conf.CustomScriptConfiguration;
import io.jans.model.custom.script.type.token.TxTokenType;
import io.jans.service.custom.script.ExternalScriptService;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.ws.rs.WebApplicationException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;

@ApplicationScoped
public class ExternalTxTokenService
extends ExternalScriptService {
    public ExternalTxTokenService() {
        super(CustomScriptType.TX_TOKEN);
    }

    public boolean modifyTokenPayload(CustomScriptConfiguration script, JsonWebResponse jsonWebResponse, ExternalScriptContext context) {
        try {
            this.log.trace("Executing 'modifyTokenPayload' method, script name: {}, jsonWebResponse: {}, context: {}", new Object[]{script.getName(), jsonWebResponse, context});
            context.getExecutionContext().setScript(script);
            TxTokenType scriptType = (TxTokenType)script.getExternalType();
            boolean result = scriptType.modifyTokenPayload((Object)jsonWebResponse, (Object)context);
            this.log.trace("Finished 'modifyTokenPayload' method, script name: {}, jsonWebResponse: {}, context: {}, result: {}", new Object[]{script.getName(), jsonWebResponse, context, result});
            context.throwWebApplicationExceptionIfSet();
            return result;
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            this.saveScriptError(script.getCustomScript(), ex);
            return false;
        }
    }

    public boolean modifyTokenPayload(JsonWebResponse jsonWebResponse, ExternalScriptContext context) {
        List<CustomScriptConfiguration> scripts = this.getScripts(context.getExecutionContext());
        if (scripts.isEmpty()) {
            return true;
        }
        this.log.trace("Executing {} 'modifyTokenPayload' scripts.", (Object)scripts.size());
        for (CustomScriptConfiguration script : scripts) {
            if (this.modifyTokenPayload(script, jsonWebResponse, context)) continue;
            return false;
        }
        return true;
    }

    public boolean modifyResponse(CustomScriptConfiguration script, JSONObject response, ExternalScriptContext context) {
        try {
            this.log.trace("Executing 'modifyResponse' method, script name: {}, response: {}, context: {}", new Object[]{script.getName(), response, context});
            context.getExecutionContext().setScript(script);
            TxTokenType scriptType = (TxTokenType)script.getExternalType();
            boolean result = scriptType.modifyResponse((Object)response, (Object)context);
            this.log.trace("Finished 'modifyResponse' method, script name: {}, response: {}, context: {}, result: {}", new Object[]{script.getName(), response, context, result});
            context.throwWebApplicationExceptionIfSet();
            return result;
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            this.saveScriptError(script.getCustomScript(), ex);
            return false;
        }
    }

    public boolean modifyResponse(JSONObject response, ExternalScriptContext context) {
        List<CustomScriptConfiguration> scripts = this.getScripts(context.getExecutionContext());
        if (scripts.isEmpty()) {
            this.log.trace("No TxTokenType scripts found.");
            return true;
        }
        this.log.trace("Executing {} 'modifyResponse' scripts.", (Object)scripts.size());
        for (CustomScriptConfiguration script : scripts) {
            if (this.modifyResponse(script, response, context)) continue;
            return false;
        }
        return true;
    }

    public int getTxTokenLifetimeInSeconds(CustomScriptConfiguration script, ExternalScriptContext context) {
        try {
            this.log.trace("Executing 'getTxTokenLifetimeInSeconds' method, script name: {}, context: {}", (Object)script.getName(), (Object)context);
            context.getExecutionContext().setScript(script);
            TxTokenType txTokenType = (TxTokenType)script.getExternalType();
            int result = txTokenType.getTxTokenLifetimeInSeconds((Object)context);
            this.log.trace("Finished 'getTxTokenLifetimeInSeconds' method, script name: {}, context: {}, result: {}", new Object[]{script.getName(), context, result});
            context.throwWebApplicationExceptionIfSet();
            return result;
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            this.saveScriptError(script.getCustomScript(), ex);
            return 0;
        }
    }

    public int getTxTokenLifetimeInSeconds(ExternalScriptContext context) {
        List<CustomScriptConfiguration> scripts = this.getScripts(context.getExecutionContext());
        if (scripts.isEmpty()) {
            return 0;
        }
        this.log.trace("Executing {} 'getTxTokenLifetimeInSeconds' scripts.", (Object)scripts.size());
        for (CustomScriptConfiguration script : scripts) {
            int lifetime = this.getTxTokenLifetimeInSeconds(script, context);
            if (lifetime <= 0) continue;
            this.log.trace("Finished 'getTxTokenLifetimeInSeconds' methods, lifetime: {}", (Object)lifetime);
            return lifetime;
        }
        return 0;
    }

    @NotNull
    private List<CustomScriptConfiguration> getScripts(@NotNull ExecutionContext context) {
        if (this.customScriptConfigurations == null || this.customScriptConfigurations.isEmpty() || context.getClient() == null) {
            this.log.trace("No TxToken scripts or client is null.");
            return Lists.newArrayList();
        }
        List scripts = this.getCustomScriptConfigurationsByDns(context.getClient().getAttributes().getTxTokenScriptDns());
        if (!scripts.isEmpty()) {
            return scripts;
        }
        this.log.trace("No TxToken scripts associated with client {}", (Object)context.getClient().getClientId());
        return Lists.newArrayList();
    }
}

