/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.service.external.context;

import com.google.common.collect.Sets;
import io.jans.as.common.model.session.SessionId;
import io.jans.as.server.service.external.context.ExternalScriptContext;
import io.jans.model.custom.script.conf.CustomScriptConfiguration;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Set;

public class EndSessionContext
extends ExternalScriptContext {
    private CustomScriptConfiguration script;
    private final Set<String> frontchannelLogoutUris;
    private final String postLogoutRedirectUri;
    private final SessionId sessionId;

    public EndSessionContext(HttpServletRequest httpRequest, Set<String> frontchannelLogoutUris, String postLogoutRedirectUri, SessionId sessionId) {
        super(httpRequest);
        this.frontchannelLogoutUris = frontchannelLogoutUris;
        this.postLogoutRedirectUri = postLogoutRedirectUri;
        this.sessionId = sessionId;
    }

    public SessionId getSessionId() {
        return this.sessionId;
    }

    public CustomScriptConfiguration getScript() {
        return this.script;
    }

    public void setScript(CustomScriptConfiguration script) {
        this.script = script;
    }

    public Set<String> getFrontchannelLogoutUris() {
        return Sets.newHashSet(this.frontchannelLogoutUris);
    }

    public String getPostLogoutRedirectUri() {
        return this.postLogoutRedirectUri;
    }

    public String toString() {
        return "EndSessionContext{script=" + (this.script != null ? this.script.getName() : "") + ", frontchannelLogoutUris=" + this.frontchannelLogoutUris + ", postLogoutRedirectUri='" + this.postLogoutRedirectUri + "', sessionId='" + this.sessionId + "'} " + super.toString();
    }
}

