/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.service.external.context;

import io.jans.as.model.authzdetails.AuthzDetail;
import io.jans.as.model.util.Util;
import io.jans.as.server.authorize.ws.rs.AuthzRequest;
import io.jans.as.server.model.common.ExecutionContext;
import io.jans.as.server.util.ServerUtil;
import io.jans.orm.PersistenceEntryManager;
import io.jans.orm.exception.EntryPersistenceException;
import io.jans.orm.model.base.CustomEntry;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.core.CacheControl;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import org.apache.commons.net.util.SubnetUtils;
import org.jboss.resteasy.spi.NoLogWebApplicationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalScriptContext
extends io.jans.service.external.context.ExternalScriptContext {
    private static final Logger log = LoggerFactory.getLogger(ExternalScriptContext.class);
    private PersistenceEntryManager persistenceEntryManager;
    private ExecutionContext executionContext;
    private NoLogWebApplicationException webApplicationException;

    public ExternalScriptContext(ExecutionContext executionContext) {
        this(executionContext.getHttpRequest(), executionContext.getHttpResponse());
        this.executionContext = executionContext;
    }

    public ExternalScriptContext(HttpServletRequest httpRequest) {
        this(httpRequest, null);
    }

    public ExternalScriptContext(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        super(httpRequest, httpResponse);
    }

    public static ExternalScriptContext of(ExecutionContext executionContext) {
        return new ExternalScriptContext(executionContext);
    }

    public String getRequestParameter(String parameterName) {
        return this.httpRequest != null ? this.httpRequest.getParameter(parameterName) : null;
    }

    public ExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    public AuthzRequest getAuthzRequest() {
        return this.executionContext != null ? this.executionContext.getAuthzRequest() : null;
    }

    public AuthzDetail getAuthzDetail() {
        return this.executionContext != null ? this.executionContext.getAuthzDetail() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PersistenceEntryManager getPersistenceEntryManager() {
        if (this.persistenceEntryManager == null) {
            ExternalScriptContext externalScriptContext = this;
            synchronized (externalScriptContext) {
                if (this.persistenceEntryManager == null) {
                    this.persistenceEntryManager = ServerUtil.getLdapManager();
                }
            }
        }
        return this.persistenceEntryManager;
    }

    public boolean isInNetwork(String cidrNotation) {
        String ip = this.getIpAddress();
        if (Util.allNotBlank((String[])new String[]{ip, cidrNotation})) {
            SubnetUtils utils = new SubnetUtils(cidrNotation);
            return utils.getInfo().isInRange(ip);
        }
        return false;
    }

    protected CustomEntry getEntryByDn(String dn, String ... ldapReturnAttributes) {
        try {
            return (CustomEntry)this.getPersistenceEntryManager().find((Object)dn, CustomEntry.class, ldapReturnAttributes);
        }
        catch (EntryPersistenceException epe) {
            log.error("Failed to find entry '{}'", (Object)dn);
            return null;
        }
    }

    protected String getEntryAttributeValue(String dn, String attributeName) {
        CustomEntry entry = this.getEntryByDn(dn, attributeName);
        if (entry != null) {
            return entry.getCustomAttributeValue(attributeName);
        }
        return "";
    }

    public NoLogWebApplicationException getWebApplicationException() {
        return this.webApplicationException;
    }

    public void setWebApplicationException(NoLogWebApplicationException webApplicationException) {
        this.webApplicationException = webApplicationException;
    }

    public NoLogWebApplicationException createWebApplicationException(Response response) {
        return new NoLogWebApplicationException(response);
    }

    public NoLogWebApplicationException createWebApplicationException(int status, String entity) {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoStore(true);
        this.webApplicationException = new NoLogWebApplicationException(Response.status((int)status).entity((Object)entity).type(MediaType.APPLICATION_JSON_TYPE).cacheControl(cacheControl).build());
        return this.webApplicationException;
    }

    public void throwWebApplicationExceptionIfSet() {
        if (this.webApplicationException != null) {
            throw this.webApplicationException;
        }
    }
}

