/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.service.external.context;

import com.google.common.collect.Lists;
import io.jans.as.common.model.registration.Client;
import io.jans.as.common.service.AttributeService;
import io.jans.as.model.common.GrantType;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.model.jwt.Jwt;
import io.jans.as.model.jwt.JwtClaims;
import io.jans.as.model.jwt.JwtHeader;
import io.jans.as.server.model.common.AccessToken;
import io.jans.as.server.model.common.AuthorizationGrant;
import io.jans.as.server.model.common.ExecutionContext;
import io.jans.as.server.model.token.JwtSigner;
import io.jans.as.server.service.external.context.ExternalScriptContext;
import io.jans.model.custom.script.conf.CustomScriptConfiguration;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalUpdateTokenContext
extends ExternalScriptContext {
    private static final Logger log = LoggerFactory.getLogger(ExternalUpdateTokenContext.class);
    private Client client;
    private AuthorizationGrant grant;
    private AppConfiguration appConfiguration;
    private AttributeService attributeService;
    private CustomScriptConfiguration script;
    @Nullable
    private ExecutionContext executionContext;
    private JwtSigner jwtSigner;

    public ExternalUpdateTokenContext() {
        super((HttpServletRequest)null);
    }

    public ExternalUpdateTokenContext(HttpServletRequest httpRequest, AuthorizationGrant grant, Client client, AppConfiguration appConfiguration, AttributeService attributeService) {
        super(httpRequest);
        this.client = client;
        this.grant = grant;
        this.appConfiguration = appConfiguration;
        this.attributeService = attributeService;
    }

    public static ExternalUpdateTokenContext of(ExecutionContext executionContext) {
        return ExternalUpdateTokenContext.of(executionContext, null);
    }

    public static ExternalUpdateTokenContext of(ExecutionContext executionContext, JwtSigner jwtSigner) {
        ExternalUpdateTokenContext context = new ExternalUpdateTokenContext(executionContext.getHttpRequest(), executionContext.getGrant(), executionContext.getClient(), executionContext.getAppConfiguration(), executionContext.getAttributeService());
        context.setExecutionContext(executionContext);
        context.setJwtSigner(jwtSigner);
        context.setGrant(executionContext.getGrant());
        return context;
    }

    public ExecutionContext toExecutionContext() {
        if (this.executionContext == null) {
            this.executionContext = this.createExecutionContext();
        }
        return this.executionContext;
    }

    private ExecutionContext createExecutionContext() {
        ExecutionContext result = new ExecutionContext(this.httpRequest, this.httpResponse);
        result.setGrant(this.grant);
        result.setClient(this.client);
        result.setAppConfiguration(this.appConfiguration);
        result.setAttributeService(this.attributeService);
        result.setScript(this.script);
        return result;
    }

    public JwtClaims getClaims() {
        Jwt jwt = this.getJwt();
        return jwt != null ? jwt.getClaims() : null;
    }

    public JwtHeader getHeader() {
        Jwt jwt = this.getJwt();
        return jwt != null ? jwt.getHeader() : null;
    }

    public Jwt getJwt() {
        return this.jwtSigner != null ? this.jwtSigner.getJwt() : null;
    }

    public JwtSigner getJwtSigner() {
        return this.jwtSigner;
    }

    public void setJwtSigner(JwtSigner jwtSigner) {
        this.jwtSigner = jwtSigner;
    }

    public CustomScriptConfiguration getScript() {
        return this.script;
    }

    public void setScript(CustomScriptConfiguration script) {
        this.script = script;
    }

    public Client getClient() {
        return this.client;
    }

    public void setClient(Client client) {
        this.client = client;
    }

    public AuthorizationGrant getGrant() {
        return this.grant;
    }

    public void setGrant(AuthorizationGrant grant) {
        this.grant = grant;
    }

    public AppConfiguration getAppConfiguration() {
        return this.appConfiguration;
    }

    public AttributeService getAttributeService() {
        return this.attributeService;
    }

    public boolean isRefreshingGrant() {
        return this.grant != null && this.grant.getGrantType() == GrantType.REFRESH_TOKEN;
    }

    @Override
    @Nullable
    public ExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    public void setExecutionContext(@Nullable ExecutionContext executionContext) {
        this.executionContext = executionContext;
    }

    public void overwriteAccessTokenScopes(AccessToken accessToken, Set<String> newScopes) {
        if (this.grant == null) {
            return;
        }
        this.grant.setScopes(newScopes);
        Jwt jwt = this.getJwt();
        if (jwt != null) {
            jwt.getClaims().setClaim("scope", (List)Lists.newArrayList(newScopes));
        }
    }

    private boolean isValidJwt(String jwt) {
        return Jwt.parseSilently((String)jwt) != null;
    }
}

