/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.ssa.ws.rs.action;

import io.jans.as.client.ssa.create.SsaCreateRequest;
import io.jans.as.common.model.registration.Client;
import io.jans.as.common.model.ssa.Ssa;
import io.jans.as.common.model.ssa.SsaState;
import io.jans.as.common.service.common.InumService;
import io.jans.as.model.common.CreatorType;
import io.jans.as.model.common.FeatureFlagType;
import io.jans.as.model.config.StaticConfiguration;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.model.error.ErrorResponseFactory;
import io.jans.as.model.error.IErrorType;
import io.jans.as.model.jwt.Jwt;
import io.jans.as.model.ssa.SsaErrorResponseType;
import io.jans.as.model.ssa.SsaRequestParam;
import io.jans.as.model.ssa.SsaScopeType;
import io.jans.as.model.token.JsonWebResponse;
import io.jans.as.server.model.common.ExecutionContext;
import io.jans.as.server.service.external.ModifySsaResponseService;
import io.jans.as.server.service.external.context.ModifySsaResponseContext;
import io.jans.as.server.ssa.ws.rs.SsaContextBuilder;
import io.jans.as.server.ssa.ws.rs.SsaJsonService;
import io.jans.as.server.ssa.ws.rs.SsaRestWebServiceValidator;
import io.jans.as.server.ssa.ws.rs.SsaService;
import io.jans.as.server.util.ServerUtil;
import jakarta.ejb.Stateless;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;
import org.slf4j.Logger;

@Stateless
@Named
public class SsaCreateAction {
    @Inject
    private Logger log;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private InumService inumService;
    @Inject
    private StaticConfiguration staticConfiguration;
    @Inject
    private SsaJsonService ssaJsonService;
    @Inject
    private SsaService ssaService;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private ModifySsaResponseService modifySsaResponseService;
    @Inject
    private SsaRestWebServiceValidator ssaRestWebServiceValidator;
    @Inject
    private SsaContextBuilder ssaContextBuilder;

    public Response create(String requestParams, HttpServletRequest httpRequest) throws WebApplicationException {
        this.errorResponseFactory.validateFeatureEnabled(FeatureFlagType.SSA);
        this.log.trace("Ssa request = {}", (Object)requestParams);
        Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.CREATED);
        try {
            JSONObject jsonRequest = new JSONObject(requestParams);
            SsaCreateRequest ssaCreateRequest = SsaCreateRequest.fromJson((JSONObject)jsonRequest);
            this.log.debug("Attempting to create ssa: {}", (Object)ssaCreateRequest);
            this.prepareCreateRequest(ssaCreateRequest);
            this.ssaRestWebServiceValidator.validateSsaCreateRequest(ssaCreateRequest);
            String ssaBaseDN = this.staticConfiguration.getBaseDn().getSsa();
            String inum = this.inumService.generateDefaultId();
            Client client = this.ssaRestWebServiceValidator.getClientFromSession();
            this.ssaRestWebServiceValidator.checkScopesPolicy(client, SsaScopeType.SSA_ADMIN.getValue());
            Date creationDate = new Date();
            Date expirationDate = this.getExpiration(ssaCreateRequest.getExpiration());
            Ssa ssa = new Ssa();
            ssa.setDn("inum=" + inum + "," + ssaBaseDN);
            ssa.setId(inum);
            ssa.setDeletable(Boolean.valueOf(true));
            ssa.setOrgId(ssaCreateRequest.getOrgId());
            ssa.setExpirationDate(expirationDate);
            ssa.setTtl(Integer.valueOf(ServerUtil.calculateTtl(creationDate, expirationDate)));
            ssa.setDescription(ssaCreateRequest.getDescription());
            ssa.getAttributes().setSoftwareId(ssaCreateRequest.getSoftwareId());
            ssa.getAttributes().setSoftwareRoles(ssaCreateRequest.getSoftwareRoles());
            ssa.getAttributes().setScopes(this.getScopesForRoles(ssaCreateRequest.getSoftwareRoles()));
            ssa.getAttributes().setGrantTypes(ssaCreateRequest.getGrantTypes());
            ssa.getAttributes().setCustomAttributes(this.getCustomAttributes(jsonRequest));
            ssa.getAttributes().setClientDn(client.getDn());
            ssa.getAttributes().setOneTimeUse(ssaCreateRequest.getOneTimeUse());
            ssa.getAttributes().setRotateSsa(ssaCreateRequest.getRotateSsa());
            ssa.getAttributes().setLifetime(ssaCreateRequest.getLifetime());
            ssa.setCreatorType(CreatorType.CLIENT);
            ssa.setState(SsaState.ACTIVE);
            ssa.setCreatorId(client.getClientId());
            ssa.setCreationDate(creationDate);
            ModifySsaResponseContext context = this.ssaContextBuilder.buildModifySsaResponseContext(httpRequest, client);
            Function<JsonWebResponse, Void> postProcessor = this.modifySsaResponseService.buildCreateProcessor(context);
            ExecutionContext executionContext = context.toExecutionContext();
            executionContext.setPostProcessor(postProcessor);
            Jwt jwt = this.ssaService.generateJwt(ssa, executionContext);
            this.ssaService.persist(ssa);
            this.log.info("Ssa created: {}", (Object)ssa);
            JSONObject jsonResponse = this.ssaJsonService.getJSONObject(jwt.toString());
            builder.entity((Object)this.ssaJsonService.jsonObjectToString(jsonResponse));
        }
        catch (WebApplicationException e) {
            if (this.log.isErrorEnabled()) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
            throw e;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR, (IErrorType)SsaErrorResponseType.UNKNOWN_ERROR, "Unknown error");
        }
        builder.cacheControl(ServerUtil.cacheControl(true, false));
        builder.header("Pragma", (Object)"no-cache");
        builder.type(MediaType.APPLICATION_JSON_TYPE);
        return builder.build();
    }

    private List<String> getScopesForRoles(List<String> softwareRoles) {
        this.log.debug("scopesForRoles - softwareRoles: {}", softwareRoles);
        Map map = this.appConfiguration.getSsaConfiguration().getSsaMapSoftwareRolesToScopes();
        if (map == null || map.isEmpty()) {
            this.log.debug("scopesForRoles - no mappings in ssaConfiguration.ssaMapSoftwareRolesToScopes");
            return new ArrayList<String>();
        }
        List<String> scopes = new ArrayList<String>();
        for (String role : softwareRoles) {
            List scopesFromMap = (List)map.get(role);
            if (scopesFromMap == null || scopes.size() >= scopesFromMap.size()) continue;
            scopes = scopesFromMap;
            this.log.debug("scopesForRoles - set scopes: {} for role: {}", scopes, (Object)role);
        }
        this.log.debug("scopesForRoles - scopes: {}", scopes);
        return scopes;
    }

    private void prepareCreateRequest(SsaCreateRequest request) {
        if (request.getExpiration() == null || request.getExpiration() == 0L) {
            Date expiration = this.getExpiration(request.getExpiration());
            request.setExpiration(Long.valueOf(expiration.getTime() / 1000L));
        }
        if (request.getLifetime() == null || request.getLifetime() < 1) {
            int lifetime = (int)(request.getExpiration() - new Date().getTime() / 1000L);
            request.setLifetime(Integer.valueOf(lifetime));
        }
        if (StringUtils.isBlank((CharSequence)request.getSoftwareId())) {
            request.setSoftwareId(UUID.randomUUID().toString());
        }
    }

    private Map<String, String> getCustomAttributes(JSONObject jsonRequest) {
        if (this.appConfiguration.getSsaConfiguration().getSsaCustomAttributes().isEmpty()) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> customAttributes = new HashMap<String, String>();
        this.appConfiguration.getSsaConfiguration().getSsaCustomAttributes().forEach(customAttrKey -> {
            if (jsonRequest.has(customAttrKey)) {
                customAttributes.put((String)customAttrKey, jsonRequest.getString(customAttrKey));
            } else {
                this.log.warn("Field: {} is not found in request", customAttrKey);
            }
        });
        ArrayList<String> ssaFields = new ArrayList<String>();
        ssaFields.add(SsaRequestParam.DESCRIPTION.getName());
        ssaFields.add(SsaRequestParam.GRANT_TYPES.getName());
        ssaFields.add(SsaRequestParam.SOFTWARE_ROLES.getName());
        ssaFields.add(SsaRequestParam.ORG_ID.getName());
        ssaFields.add(SsaRequestParam.EXPIRATION.getName());
        ssaFields.add(SsaRequestParam.SOFTWARE_ID.getName());
        ssaFields.add(SsaRequestParam.ONE_TIME_USE.getName());
        ssaFields.add(SsaRequestParam.ROTATE_SSA.getName());
        ssaFields.add(SsaRequestParam.LIFETIME.getName());
        ssaFields.addAll(this.appConfiguration.getSsaConfiguration().getSsaCustomAttributes());
        jsonRequest.toMap().forEach((k, v) -> {
            if (!ssaFields.contains(k)) {
                this.log.warn("Field: {} is not defined", k);
            }
        });
        return customAttributes;
    }

    private Date getExpiration(Long expiration) {
        Calendar calendar = GregorianCalendar.getInstance(TimeZone.getTimeZone("UTC"));
        if (expiration != null && expiration > 0L) {
            calendar.setTimeInMillis(expiration * 1000L);
            return calendar.getTime();
        }
        calendar.add(5, this.appConfiguration.getSsaConfiguration().getSsaExpirationInDays());
        return calendar.getTime();
    }
}

