/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.status.ws.rs;

import io.jans.as.server.service.DiscoveryService;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;

@Path(value="/")
public class StatusListAggregationRestWebService {
    @Inject
    private Logger log;
    @Inject
    private DiscoveryService discoveryService;

    @GET
    @Path(value="/status_list_aggregation")
    @Produces(value={"application/json"})
    public Response requestStatusList() {
        try {
            JSONArray array = new JSONArray();
            array.put((Object)this.discoveryService.getStatusListEndpoint());
            JSONObject json = new JSONObject();
            json.put("status_lists", (Object)array);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)json.toString()).type("application/json").build();
        }
        catch (WebApplicationException e) {
            this.log.debug(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }
}

