/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.status.ws.rs;

import io.jans.as.server.service.token.StatusListService;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import org.slf4j.Logger;

@Path(value="/")
public class StatusListRestWebService {
    @Inject
    private Logger log;
    @Inject
    private StatusListService statusService;

    @GET
    @Path(value="/status_list")
    @Consumes(value={"application/statuslist+json", "application/statuslist+jwt"})
    @Produces(value={"application/statuslist+json", "application/statuslist+jwt"})
    public Response requestStatusList(@HeaderParam(value="Accept") String acceptHeader, @QueryParam(value="time") String time) {
        try {
            return this.statusService.requestStatusList(acceptHeader, time);
        }
        catch (WebApplicationException e) {
            this.log.debug(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }
}

