/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.uma.ws.rs;

import io.jans.as.model.common.FeatureFlagType;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.model.error.ErrorResponseFactory;
import io.jans.as.model.error.IErrorType;
import io.jans.as.model.uma.UmaErrorResponseType;
import io.jans.as.model.uma.UmaResourceResponse;
import io.jans.as.model.uma.UmaResourceWithId;
import io.jans.as.model.uma.persistence.UmaResource;
import io.jans.as.model.util.Util;
import io.jans.as.server.model.common.AuthorizationGrant;
import io.jans.as.server.uma.service.UmaResourceService;
import io.jans.as.server.uma.service.UmaScopeService;
import io.jans.as.server.uma.service.UmaValidationService;
import io.jans.as.server.util.ServerUtil;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HEAD;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.OPTIONS;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

@Path(value="/host/rsrc/resource_set")
public class UmaResourceRegistrationWS {
    private static final int NOT_ALLOWED_STATUS = 405;
    private static final int DEFAULT_RESOURCE_LIFETIME = 2592000;
    @Inject
    private Logger log;
    @Inject
    private UmaValidationService umaValidationService;
    @Inject
    private UmaResourceService resourceService;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private UmaScopeService umaScopeService;
    @Inject
    private AppConfiguration appConfiguration;

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createResource(@HeaderParam(value="Authorization") String authorization, io.jans.as.model.uma.UmaResource resource) {
        try {
            String id = UUID.randomUUID().toString();
            this.log.trace("Try to create resource, id: {}", (Object)id);
            return this.putResourceImpl(Response.Status.CREATED, authorization, id, resource);
        }
        catch (Exception ex) {
            if (this.log.isErrorEnabled()) {
                this.log.error("Exception during resource creation", (Throwable)ex);
            }
            if (ex instanceof WebApplicationException) {
                throw (WebApplicationException)((Object)ex);
            }
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR, (IErrorType)UmaErrorResponseType.SERVER_ERROR, ex.getMessage());
        }
    }

    @PUT
    @Path(value="{rsid}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateResource(@HeaderParam(value="Authorization") String authorization, @PathParam(value="rsid") String rsid, io.jans.as.model.uma.UmaResource resource) {
        try {
            return this.putResourceImpl(Response.Status.OK, authorization, rsid, resource);
        }
        catch (Exception ex) {
            if (this.log.isErrorEnabled()) {
                this.log.error("Exception during resource update, rsId: " + Util.escapeLog((Object)rsid) + ", message: " + ex.getMessage(), (Throwable)ex);
            }
            if (ex instanceof WebApplicationException) {
                throw (WebApplicationException)((Object)ex);
            }
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR, (IErrorType)UmaErrorResponseType.SERVER_ERROR, ex.getMessage());
        }
    }

    @GET
    @Path(value="{rsid}")
    @Produces(value={"application/json"})
    public Response getResource(@HeaderParam(value="Authorization") String authorization, @PathParam(value="rsid") String rsid) {
        try {
            this.errorResponseFactory.validateFeatureEnabled(FeatureFlagType.UMA);
            AuthorizationGrant authorizationGrant = this.umaValidationService.assertHasProtectionScope(authorization);
            this.umaValidationService.validateRestrictedByClient(authorizationGrant.getClientDn(), rsid);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Getting resource description: '{}'", (Object)Util.escapeLog((Object)rsid));
            }
            UmaResource ldapResource = this.resourceService.getResourceById(rsid);
            UmaResourceWithId response = new UmaResourceWithId();
            response.setId(ldapResource.getId());
            response.setName(ldapResource.getName());
            response.setDescription(ldapResource.getDescription());
            response.setIconUri(ldapResource.getIconUri());
            response.setScopes(this.umaScopeService.getScopeIdsByDns(ldapResource.getScopes()));
            response.setScopeExpression(ldapResource.getScopeExpression());
            response.setType(ldapResource.getType());
            response.setIat(ServerUtil.dateToSeconds(ldapResource.getCreationDate()));
            response.setExp(ServerUtil.dateToSeconds(ldapResource.getExpirationDate()));
            Response.ResponseBuilder builder = Response.ok();
            builder.entity((Object)ServerUtil.asJson(response));
            return builder.build();
        }
        catch (Exception ex) {
            if (this.log.isErrorEnabled()) {
                this.log.error("Exception happened", (Throwable)ex);
            }
            if (ex instanceof WebApplicationException) {
                throw (WebApplicationException)((Object)ex);
            }
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR, (IErrorType)UmaErrorResponseType.SERVER_ERROR, ex.getMessage());
        }
    }

    @GET
    @Produces(value={"application/json"})
    public List<String> getResourceList(@HeaderParam(value="Authorization") String authorization, @QueryParam(value="scope") String scope) {
        try {
            this.log.trace("Getting list of resource descriptions.");
            this.errorResponseFactory.validateFeatureEnabled(FeatureFlagType.UMA);
            AuthorizationGrant authorizationGrant = this.umaValidationService.assertHasProtectionScope(authorization);
            String clientDn = authorizationGrant.getClientDn();
            List<UmaResource> ldapResources = this.resourceService.getResourcesByAssociatedClient(clientDn);
            ArrayList<String> result = new ArrayList<String>(ldapResources.size());
            for (UmaResource ldapResource : ldapResources) {
                if (StringUtils.isNotBlank((CharSequence)scope)) {
                    List<String> scopeUrlsByDns = this.umaScopeService.getScopeIdsByDns(ldapResource.getScopes());
                    if (scopeUrlsByDns == null || !scopeUrlsByDns.contains(scope)) continue;
                    result.add(ldapResource.getId());
                    continue;
                }
                result.add(ldapResource.getId());
            }
            return result;
        }
        catch (Exception ex) {
            this.log.error("Exception happened on getResourceList()", (Throwable)ex);
            if (ex instanceof WebApplicationException) {
                throw (WebApplicationException)((Object)ex);
            }
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR, (IErrorType)UmaErrorResponseType.SERVER_ERROR, ex.getMessage());
        }
    }

    @DELETE
    @Path(value="{rsid}")
    public Response deleteResource(@HeaderParam(value="Authorization") String authorization, @PathParam(value="rsid") String rsid) {
        try {
            this.log.debug("Deleting resource descriptions'");
            this.errorResponseFactory.validateFeatureEnabled(FeatureFlagType.UMA);
            AuthorizationGrant authorizationGrant = this.umaValidationService.assertHasProtectionScope(authorization);
            this.umaValidationService.validateRestrictedByClient(authorizationGrant.getClientDn(), rsid);
            this.resourceService.remove(rsid);
            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        }
        catch (Exception ex) {
            if (this.log.isErrorEnabled()) {
                this.log.error("Error on DELETE Resource - " + ex.getMessage(), (Throwable)ex);
            }
            if (ex instanceof WebApplicationException) {
                throw (WebApplicationException)((Object)ex);
            }
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR, (IErrorType)UmaErrorResponseType.SERVER_ERROR, ex.getMessage());
        }
    }

    private Response putResourceImpl(Response.Status status, String authorization, String rsid, io.jans.as.model.uma.UmaResource resource) throws IOException {
        UmaResource ldapUpdatedResource;
        if (this.log.isTraceEnabled()) {
            this.log.trace("putResourceImpl, rsid: {}, status: {}", (Object)Util.escapeLog((Object)rsid), (Object)status.name());
        }
        this.errorResponseFactory.validateFeatureEnabled(FeatureFlagType.UMA);
        AuthorizationGrant authorizationGrant = this.umaValidationService.assertHasProtectionScope(authorization);
        this.umaValidationService.validateResource(resource);
        String userDn = authorizationGrant.getUserDn();
        String clientDn = authorizationGrant.getClientDn();
        if (status == Response.Status.CREATED) {
            ldapUpdatedResource = this.addResource(rsid, resource, userDn, clientDn);
        } else {
            this.umaValidationService.validateRestrictedByClient(clientDn, rsid);
            ldapUpdatedResource = this.updateResource(rsid, resource);
        }
        UmaResourceResponse response = new UmaResourceResponse();
        response.setId(ldapUpdatedResource.getId());
        return Response.status((Response.Status)status).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)ServerUtil.asJson(response)).build();
    }

    private UmaResource addResource(String rsid, io.jans.as.model.uma.UmaResource resource, String userDn, String clientDn) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Adding new resource: '{}'", (Object)Util.escapeLog((Object)rsid));
        }
        String resourceDn = this.resourceService.getDnForResource(rsid);
        List<String> scopeDNs = this.umaScopeService.getScopeDNsByIdsAndAddToPersistenceIfNeeded(resource.getScopes());
        Calendar calendar = Calendar.getInstance();
        Date iat = calendar.getTime();
        Date exp = this.getExpirationDate(calendar);
        if (resource.getIat() != null && resource.getIat() > 0) {
            iat = new Date((long)resource.getIat().intValue() * 1000L);
        }
        if (resource.getExp() != null && resource.getExp() > 0) {
            exp = new Date((long)resource.getExp().intValue() * 1000L);
        }
        UmaResource ldapResource = new UmaResource();
        ldapResource.setName(resource.getName());
        ldapResource.setDescription(resource.getDescription());
        ldapResource.setIconUri(resource.getIconUri());
        ldapResource.setId(rsid);
        ldapResource.setCreator(userDn);
        ldapResource.setDn(resourceDn);
        ldapResource.setScopes(scopeDNs);
        ldapResource.setScopeExpression(resource.getScopeExpression());
        ldapResource.setClients(new ArrayList<String>(Collections.singletonList(clientDn)));
        ldapResource.setType(resource.getType());
        ldapResource.setCreationDate(iat);
        ldapResource.setExpirationDate(exp);
        ldapResource.setTtl(Integer.valueOf(this.appConfiguration.getUmaResourceLifetime()));
        this.resourceService.addResource(ldapResource);
        return ldapResource;
    }

    private Date getExpirationDate(Calendar creationCalender) {
        int lifetime = this.appConfiguration.getUmaResourceLifetime();
        if (lifetime <= 0) {
            lifetime = 2592000;
        }
        creationCalender.add(13, lifetime);
        return creationCalender.getTime();
    }

    private UmaResource updateResource(String rsid, io.jans.as.model.uma.UmaResource resource) {
        UmaResource ldapResource;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Updating resource description: '{}'.", (Object)Util.escapeLog((Object)rsid));
        }
        if ((ldapResource = this.resourceService.getResourceById(rsid)) == null) {
            return (UmaResource)this.throwNotFoundException(rsid);
        }
        ldapResource.setName(resource.getName());
        ldapResource.setDescription(resource.getDescription());
        ldapResource.setIconUri(resource.getIconUri());
        ldapResource.setScopes(this.umaScopeService.getScopeDNsByIdsAndAddToPersistenceIfNeeded(resource.getScopes()));
        ldapResource.setScopeExpression(resource.getScopeExpression());
        ldapResource.setType(resource.getType());
        if (resource.getExp() != null && resource.getExp() > 0) {
            ldapResource.setExpirationDate(new Date((long)resource.getExp().intValue() * 1000L));
            ldapResource.setTtl(Integer.valueOf(this.appConfiguration.getUmaResourceLifetime()));
        }
        this.resourceService.updateResource(ldapResource);
        return ldapResource;
    }

    private <T> T throwNotFoundException(String rsid) {
        if (this.log.isErrorEnabled()) {
            this.log.error("Specified resource description doesn't exist, id: {}", (Object)Util.escapeLog((Object)rsid));
        }
        throw this.errorResponseFactory.createWebApplicationException(Response.Status.NOT_FOUND, (IErrorType)UmaErrorResponseType.NOT_FOUND, "Resource does not exists.");
    }

    @HEAD
    public Response unsupportedHeadMethod() {
        this.log.error("HEAD method is not allowed");
        throw new WebApplicationException(Response.status((int)405).entity((Object)"HEAD Method Not Allowed").build());
    }

    @OPTIONS
    public Response unsupportedOptionsMethod() {
        this.log.error("OPTIONS method is not allowed");
        throw new WebApplicationException(Response.status((int)405).entity((Object)"OPTIONS Method Not Allowed").build());
    }
}

