/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.uma.ws.rs;

import io.jans.as.model.common.FeatureFlagType;
import io.jans.as.model.error.ErrorResponseFactory;
import io.jans.as.model.error.IErrorType;
import io.jans.as.model.uma.RptIntrospectionResponse;
import io.jans.as.model.uma.UmaErrorResponseType;
import io.jans.as.model.uma.UmaPermission;
import io.jans.as.server.service.ClientService;
import io.jans.as.server.service.external.ExternalUmaRptClaimsService;
import io.jans.as.server.service.external.context.ExternalUmaRptClaimsContext;
import io.jans.as.server.uma.authorization.UmaPCT;
import io.jans.as.server.uma.authorization.UmaRPT;
import io.jans.as.server.uma.service.UmaPctService;
import io.jans.as.server.uma.service.UmaRptService;
import io.jans.as.server.uma.service.UmaScopeService;
import io.jans.as.server.uma.service.UmaValidationService;
import io.jans.as.server.util.ServerUtil;
import io.jans.util.StringHelper;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONObject;
import org.slf4j.Logger;

@Path(value="/rpt/status")
public class UmaRptIntrospectionWS {
    @Inject
    private Logger log;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private UmaRptService rptService;
    @Inject
    private UmaValidationService umaValidationService;
    @Inject
    private UmaScopeService umaScopeService;
    @Inject
    private UmaPctService pctService;
    @Inject
    private ExternalUmaRptClaimsService externalUmaRptClaimsService;
    @Inject
    private ClientService clientService;

    @GET
    @Produces(value={"application/json"})
    public Response introspectGet(@HeaderParam(value="Authorization") String authorization, @QueryParam(value="token") String token, @QueryParam(value="token_type_hint") String tokenTypeHint, @Context HttpServletRequest httpRequest, @Context HttpServletResponse httpResponse) {
        return this.introspect(authorization, token, httpRequest, httpResponse);
    }

    @POST
    @Produces(value={"application/json"})
    public Response introspectPost(@HeaderParam(value="Authorization") String authorization, @FormParam(value="token") String token, @FormParam(value="token_type_hint") String tokenTypeHint, @Context HttpServletRequest httpRequest, @Context HttpServletResponse httpResponse) {
        return this.introspect(authorization, token, httpRequest, httpResponse);
    }

    private Response introspect(String authorization, String token, HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        try {
            ExternalUmaRptClaimsContext context;
            JSONObject rptAsJson;
            this.errorResponseFactory.validateFeatureEnabled(FeatureFlagType.UMA);
            this.umaValidationService.assertHasProtectionScope(authorization);
            UmaRPT rpt = this.rptService.getRPTByCode(token);
            if (!this.isValid(rpt)) {
                return Response.status((Response.Status)Response.Status.OK).entity((Object)new RptIntrospectionResponse(false)).cacheControl(ServerUtil.cacheControl(true)).build();
            }
            List<UmaPermission> permissions = this.buildStatusResponsePermissions(rpt);
            RptIntrospectionResponse statusResponse = new RptIntrospectionResponse();
            statusResponse.setActive(true);
            statusResponse.setExpiresAt(ServerUtil.dateToSeconds(rpt.getExpirationDate()));
            statusResponse.setIssuedAt(ServerUtil.dateToSeconds(rpt.getCreationDate()));
            statusResponse.setPermissions(permissions);
            statusResponse.setClientId(rpt.getClientId());
            statusResponse.setAud(rpt.getClientId());
            statusResponse.setSub(rpt.getUserId());
            List<io.jans.as.model.uma.persistence.UmaPermission> rptPermissions = this.rptService.getRptPermissions(rpt);
            if (!rptPermissions.isEmpty()) {
                io.jans.as.model.uma.persistence.UmaPermission permission = rptPermissions.iterator().next();
                String pctCode = (String)permission.getAttributes().get("pct");
                if (StringHelper.isNotEmpty((String)pctCode)) {
                    UmaPCT pct = this.pctService.getByCode(pctCode);
                    if (pct != null) {
                        statusResponse.setPctClaims(pct.getClaims().toMap());
                    } else {
                        this.log.error("Failed to find PCT with code: {} which is taken from permission object: {}", (Object)pctCode, (Object)permission.getDn());
                    }
                } else {
                    this.log.trace("PCT code is blank for RPT: {}", (Object)rpt.getCode());
                }
            }
            if (this.externalUmaRptClaimsService.externalModify(rptAsJson = new JSONObject(ServerUtil.asJson(statusResponse)), context = new ExternalUmaRptClaimsContext(this.clientService.getClient(rpt.getClientId()), httpRequest, httpResponse))) {
                this.log.trace("Successfully run external RPT Claims script associated with {}", (Object)rpt.getClientId());
            } else {
                rptAsJson = new JSONObject(ServerUtil.asJson(statusResponse));
                this.log.trace("Canceled changes made by external RPT Claims script since method returned `false`.");
            }
            return Response.status((Response.Status)Response.Status.OK).entity((Object)rptAsJson.toString()).type(MediaType.APPLICATION_JSON_TYPE).cacheControl(ServerUtil.cacheControl(true)).build();
        }
        catch (Exception ex) {
            this.log.error("Exception happened", (Throwable)ex);
            if (ex instanceof WebApplicationException) {
                throw (WebApplicationException)((Object)ex);
            }
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR, (IErrorType)UmaErrorResponseType.SERVER_ERROR, "Internal error.");
        }
    }

    private boolean isValid(UmaRPT rpt) {
        if (rpt != null) {
            rpt.checkExpired();
            return rpt.isValid();
        }
        return false;
    }

    private boolean isValid(io.jans.as.model.uma.persistence.UmaPermission permission) {
        permission.checkExpired();
        return permission.isValid();
    }

    private List<UmaPermission> buildStatusResponsePermissions(UmaRPT rpt) {
        List<io.jans.as.model.uma.persistence.UmaPermission> rptPermissions;
        ArrayList<UmaPermission> result = new ArrayList<UmaPermission>();
        if (rpt != null && (rptPermissions = this.rptService.getRptPermissions(rpt)) != null && !rptPermissions.isEmpty()) {
            for (io.jans.as.model.uma.persistence.UmaPermission permission : rptPermissions) {
                if (this.isValid(permission)) {
                    UmaPermission toAdd = ServerUtil.convert(permission, this.umaScopeService);
                    if (toAdd == null) continue;
                    result.add(toAdd);
                    continue;
                }
                this.log.debug("Ignore permission, skip it in response because permission is not valid. Permission dn: {}, rpt dn: {}", (Object)permission.getDn(), (Object)rpt.getDn());
            }
        }
        return result;
    }

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response requestRptStatusGet(@HeaderParam(value="Authorization") String authorization, @FormParam(value="token") String rpt, @FormParam(value="token_type_hint") String tokenTypeHint) {
        throw new WebApplicationException(Response.status((int)405).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)"Introspection of RPT is not allowed by GET HTTP method.").build());
    }
}

