/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.datatype.jsonorg.JsonOrgModule;
import io.jans.as.model.uma.UmaPermission;
import io.jans.as.server.uma.service.UmaScopeService;
import io.jans.orm.PersistenceEntryManager;
import io.jans.orm.model.base.CustomAttribute;
import io.jans.service.cdi.util.CdiUtil;
import io.jans.util.ArrayHelper;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.core.CacheControl;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerUtil {
    private static final Logger log = LoggerFactory.getLogger(ServerUtil.class);
    private static final String[] HEADERS_TO_TRY = new String[]{"X-Forwarded-For", "Proxy-Client-IP", "WL-Proxy-Client-IP", "HTTP_X_FORWARDED_FOR", "HTTP_X_FORWARDED", "HTTP_X_CLUSTER_CLIENT_IP", "HTTP_CLIENT_IP", "HTTP_FORWARDED_FOR", "HTTP_FORWARDED", "HTTP_VIA", "REMOTE_ADDR"};

    private ServerUtil() {
    }

    public static String sanitizeUsernameForLog(String username) {
        if (username == null) {
            return "unknown_user";
        }
        int maximumUsernameLength = 50;
        username = username.length() > 50 ? username.substring(0, 50) : username;
        return StringEscapeUtils.escapeJava((String)username).replaceAll("[\\r\\n]", "_");
    }

    public static Map<String, String[]> prepareForLogs(Map<String, String[]> parameters) {
        if (parameters == null || parameters.isEmpty()) {
            return new HashMap<String, String[]>();
        }
        HashMap<String, String[]> result = new HashMap<String, String[]>(parameters);
        if (result.containsKey("client_secret")) {
            result.put("client_secret", new String[]{"*****"});
        }
        if (result.containsKey("password")) {
            result.put("password", new String[]{"*****"});
        }
        return result;
    }

    public static GregorianCalendar now() {
        return new GregorianCalendar(TimeZone.getTimeZone("UTC"));
    }

    public static int nowAsSeconds() {
        return (int)(new Date().getTime() / 1000L);
    }

    public static int calculateTtl(Integer expirationDateAsSeconds) {
        if (expirationDateAsSeconds == null) {
            return 0;
        }
        return expirationDateAsSeconds - ServerUtil.nowAsSeconds();
    }

    public static int calculateTtl(Date creationDate, Date expirationDate) {
        if (creationDate != null && expirationDate != null) {
            return (int)((expirationDate.getTime() - creationDate.getTime()) / 1000L);
        }
        return 0;
    }

    public static String asJsonSilently(Object obj) {
        try {
            return ServerUtil.asJson(obj);
        }
        catch (IOException e) {
            log.trace(e.getMessage(), (Throwable)e);
            return "";
        }
    }

    public static ThreadFactory daemonThreadFactory() {
        return runnable -> {
            Thread thread = new Thread(runnable);
            thread.setDaemon(true);
            return thread;
        };
    }

    public static String asPrettyJson(Object obj) throws IOException {
        ObjectMapper mapper = ServerUtil.createJsonMapper().configure(SerializationFeature.WRAP_ROOT_VALUE, false);
        return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(obj);
    }

    public static String asJson(Object obj) throws IOException {
        ObjectMapper mapper = ServerUtil.createJsonMapper().configure(SerializationFeature.WRAP_ROOT_VALUE, false);
        return mapper.writeValueAsString(obj);
    }

    public static CacheControl cacheControl(boolean noStore) {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoStore(noStore);
        return cacheControl;
    }

    public static CacheControl cacheControl(boolean noStore, boolean noTransform) {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoStore(noStore);
        cacheControl.setNoTransform(noTransform);
        return cacheControl;
    }

    public static CacheControl cacheControlWithNoStoreTransformAndPrivate() {
        CacheControl cacheControl = ServerUtil.cacheControl(true, false);
        cacheControl.setPrivate(true);
        return cacheControl;
    }

    public static ObjectMapper createJsonMapper() {
        JacksonAnnotationIntrospector jackson = new JacksonAnnotationIntrospector();
        ObjectMapper mapper = new ObjectMapper();
        mapper.getDeserializationConfig().with((AnnotationIntrospector)jackson);
        mapper.getSerializationConfig().with((AnnotationIntrospector)jackson);
        return mapper;
    }

    public static ObjectMapper jsonMapperWithWrapRoot() {
        return ServerUtil.createJsonMapper().configure(SerializationFeature.WRAP_ROOT_VALUE, true);
    }

    public static ObjectMapper jsonMapperWithUnwrapRoot() {
        return ServerUtil.createJsonMapper().configure(DeserializationFeature.UNWRAP_ROOT_VALUE, true);
    }

    public static String toPrettyJson(JSONObject jsonObject) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)new JsonOrgModule());
        return mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)jsonObject);
    }

    public static PersistenceEntryManager getLdapManager() {
        return (PersistenceEntryManager)CdiUtil.bean(PersistenceEntryManager.class, (String)"persistenceEntryManager");
    }

    public static CustomAttribute getAttributeByName(List<CustomAttribute> list, String attributeName) {
        if (list != null && !list.isEmpty() && StringUtils.isNotEmpty((CharSequence)attributeName)) {
            for (CustomAttribute attr : list) {
                if (!attributeName.equals(attr.getName())) continue;
                return attr;
            }
        }
        return null;
    }

    public static String getAttributeValueByName(List<CustomAttribute> list, String attributeName) {
        CustomAttribute attr = ServerUtil.getAttributeByName(list, attributeName);
        if (attr != null) {
            return attr.getValue();
        }
        return "";
    }

    public static String urlDecode(String str) {
        if (StringUtils.isNotBlank((CharSequence)str)) {
            try {
                return URLDecoder.decode(str, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                log.trace(e.getMessage(), (Throwable)e);
            }
        }
        return str;
    }

    public static ScheduledExecutorService createExecutor() {
        return Executors.newSingleThreadScheduledExecutor(runnable -> {
            Thread thread = new Thread(runnable);
            thread.setDaemon(true);
            return thread;
        });
    }

    public static UmaPermission convert(io.jans.as.model.uma.persistence.UmaPermission permission, UmaScopeService umaScopeService) {
        if (permission != null) {
            UmaPermission result = new UmaPermission();
            result.setResourceId(permission.getResourceId());
            result.setScopes(umaScopeService.getScopeIdsByDns(permission.getScopeDns()));
            result.setExpiresAt(ServerUtil.dateToSeconds(permission.getExpirationDate()));
            return result;
        }
        return null;
    }

    public static String getFirstValue(Map<String, String[]> map, String key) {
        Object[] values;
        if (map.containsKey(key) && ArrayHelper.isNotEmpty((Object[])(values = map.get(key)))) {
            return values[0];
        }
        return null;
    }

    public static String getIpAddress(HttpServletRequest httpRequest) {
        for (String header : HEADERS_TO_TRY) {
            String ip = httpRequest.getHeader(header);
            if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) continue;
            return ip;
        }
        return httpRequest.getRemoteAddr();
    }

    public static HttpServletRequest getRequestOrNull() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext == null) {
            return null;
        }
        ExternalContext externalContext = facesContext.getExternalContext();
        if (externalContext == null) {
            return null;
        }
        Object request = externalContext.getRequest();
        if (!(request instanceof HttpServletRequest)) {
            return null;
        }
        return (HttpServletRequest)request;
    }

    public static boolean isSameRequestPath(String url1, String url2) throws MalformedURLException {
        if (StringUtils.isBlank((CharSequence)url1) || StringUtils.isBlank((CharSequence)url2)) {
            return false;
        }
        URL parsedUrl1 = new URL(url1);
        URL parsedUrl2 = new URL(url2);
        return parsedUrl1.getPath().endsWith(parsedUrl2.getPath());
    }

    public static Integer dateToSeconds(Date date) {
        return date != null ? Integer.valueOf((int)(date.getTime() / 1000L)) : null;
    }
}

