/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.ws.rs.controller;

import io.jans.as.model.common.FeatureFlagType;
import io.jans.as.model.error.ErrorResponseFactory;
import io.jans.as.server.model.common.ExecutionContext;
import io.jans.as.server.service.external.ExternalAuthenticationService;
import io.jans.as.server.service.external.ExternalDynamicScopeService;
import io.jans.as.server.service.external.ExternalHealthCheckService;
import io.jans.orm.PersistenceEntryManager;
import io.jans.orm.util.StringHelper;
import io.jans.service.HealthCheckPluginService;
import io.jans.service.custom.script.CustomScriptManager;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import org.apache.commons.lang3.StringUtils;

@ApplicationScoped
@Path(value="/")
public class HealthCheckController {
    @Inject
    private PersistenceEntryManager persistenceEntryManager;
    @Inject
    private ExternalAuthenticationService externalAuthenticationService;
    @Inject
    private ExternalDynamicScopeService externalDynamicScopeService;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private ExternalHealthCheckService externalHealthCheckService;
    @Inject
    private CustomScriptManager \u0441ustomScriptManager;
    @Inject
    private Instance<HealthCheckPluginService> healthCheckPluginServiceInstance;

    @GET
    @POST
    @Path(value="/health-check")
    @Produces(value={"application/json"})
    public String healthCheckController(@Context HttpServletRequest httpRequest, @Context HttpServletResponse httpResponse) {
        ExecutionContext executionContext;
        String externalResponse;
        this.errorResponseFactory.validateFeatureEnabled(FeatureFlagType.HEALTH_CHECK);
        boolean isConnected = this.persistenceEntryManager.getOperationService().isConnected();
        String dbStatus = isConnected ? "online" : "offline";
        String appStatus = this.getAppStatus();
        StringBuilder sb = new StringBuilder(String.format("{\"status\": \"%s\", \"db_status\":\"%s\"", appStatus, dbStatus));
        for (HealthCheckPluginService healthCheckPluginService : this.healthCheckPluginServiceInstance) {
            String healthCheckService = healthCheckPluginService.provideServiceName();
            String healthCheckData = healthCheckPluginService.provideHealthCheckData();
            if (!StringHelper.isNotEmpty((String)healthCheckService) || !StringHelper.isNotEmpty((String)healthCheckData)) continue;
            sb.append(String.format(", \"%s\": %s", healthCheckService, healthCheckData));
        }
        sb.append("}");
        String responseString = sb.toString();
        if (this.externalHealthCheckService.isEnabled() && StringUtils.isNotBlank((CharSequence)(externalResponse = this.externalHealthCheckService.externalHealthCheck(executionContext = new ExecutionContext(httpRequest, httpResponse))))) {
            return externalResponse;
        }
        return responseString;
    }

    public String getAppStatus() {
        if (this.externalAuthenticationService.isLoaded() && this.externalDynamicScopeService.isLoaded() && this.\u0441ustomScriptManager.isInitialized()) {
            return "running";
        }
        return "starting";
    }
}

