/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.authorize.ws.rs;

import io.jans.as.common.model.session.AuthorizationChallengeSession;
import io.jans.as.model.config.StaticConfiguration;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.orm.PersistenceEntryManager;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

@Named
@ApplicationScoped
public class AuthorizationChallengeSessionService {
    @Inject
    private Logger log;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private PersistenceEntryManager persistenceEntryManager;
    @Inject
    private StaticConfiguration staticConfiguration;

    public AuthorizationChallengeSession newAuthorizationChallengeSession() {
        String id = UUID.randomUUID().toString();
        return this.newAuthorizationChallengeSession(id);
    }

    public AuthorizationChallengeSession newAuthorizationChallengeSession(String id) {
        int lifetimeInSeconds = this.appConfiguration.getAuthorizationChallengeSessionLifetimeInSeconds();
        GregorianCalendar calendar = new GregorianCalendar();
        Date creationDate = calendar.getTime();
        ((Calendar)calendar).add(13, lifetimeInSeconds);
        Date expirationDate = calendar.getTime();
        AuthorizationChallengeSession session = new AuthorizationChallengeSession();
        session.setId(id);
        session.setDn(this.buildDn(id));
        session.setDeletable(Boolean.valueOf(true));
        session.setTtl(lifetimeInSeconds);
        session.setCreationDate(creationDate);
        session.setExpirationDate(expirationDate);
        return session;
    }

    public String buildDn(String id) {
        return String.format("jansId=%s,%s", id, this.staticConfiguration.getBaseDn().getSessions());
    }

    public AuthorizationChallengeSession getAuthorizationChallengeSessionByDn(String dn) {
        try {
            return (AuthorizationChallengeSession)this.persistenceEntryManager.find(AuthorizationChallengeSession.class, (Object)dn);
        }
        catch (Exception e) {
            this.log.trace(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public AuthorizationChallengeSession getAuthorizationChallengeSession(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            AuthorizationChallengeSession result = this.getAuthorizationChallengeSessionByDn(this.buildDn(id));
            this.log.debug("Found {} entries for authorizationChallengeSession id = {}", (Object)(result != null ? 1 : 0), (Object)id);
            return result;
        }
        return null;
    }

    public void persist(AuthorizationChallengeSession entity) {
        this.persistenceEntryManager.persist((Object)entity);
    }

    public void merge(AuthorizationChallengeSession entity) {
        this.persistenceEntryManager.merge((Object)entity);
    }
}

