/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.authzen.ws.rs;

import io.jans.as.common.model.registration.Client;
import io.jans.as.model.common.FeatureFlagType;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.model.error.ErrorResponseFactory;
import io.jans.as.server.authzen.ws.rs.AccessEvaluationValidator;
import io.jans.as.server.model.common.AbstractToken;
import io.jans.as.server.model.common.AuthorizationGrant;
import io.jans.as.server.model.common.ExecutionContext;
import io.jans.as.server.service.ClientService;
import io.jans.as.server.service.ScopeService;
import io.jans.as.server.service.external.ExternalAccessEvaluationService;
import io.jans.as.server.service.token.TokenService;
import io.jans.model.authzen.AccessEvaluationRequest;
import io.jans.model.authzen.AccessEvaluationResponse;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;

@ApplicationScoped
public class AccessEvaluationService {
    public static final String ACCESS_EVALUATION_SCOPE = "access_evaluation";
    @Inject
    private Logger log;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private ExternalAccessEvaluationService externalAccessEvaluationService;
    @Inject
    private AccessEvaluationValidator accessEvaluationValidator;
    @Inject
    private TokenService tokenService;
    @Inject
    private ClientService clientService;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private ScopeService scopeService;

    public AccessEvaluationResponse evaluation(AccessEvaluationRequest request, ExecutionContext executionContext) {
        this.errorResponseFactory.validateFeatureEnabled(FeatureFlagType.ACCESS_EVALUATION);
        this.accessEvaluationValidator.validateAccessEvaluationRequest(request);
        AccessEvaluationResponse response = this.externalAccessEvaluationService.externalEvaluate(request, executionContext);
        this.log.debug("Access Evaluation response {}", (Object)response);
        return response;
    }

    public void validateAuthorization(String authorization) {
        AuthorizationGrant grant = this.tokenService.getBearerAuthorizationGrant(authorization);
        if (grant != null) {
            String authorizationAccessToken = this.tokenService.getBearerToken(authorization);
            AbstractToken accessTokenObject = grant.getAccessToken(authorizationAccessToken);
            if (accessTokenObject != null && accessTokenObject.isValid()) {
                if (grant.getScopes() != null && grant.getScopes().contains(ACCESS_EVALUATION_SCOPE)) {
                    this.log.debug("Authorized with bearer token.");
                    return;
                }
                this.log.error("access_token does not have {} scope.", (Object)ACCESS_EVALUATION_SCOPE);
            } else {
                this.log.debug("Unable to find valid access token.");
            }
        } else {
            this.log.debug("Unable to find grant by bearer access token.");
        }
        if (BooleanUtils.isTrue((Boolean)this.appConfiguration.getAccessEvaluationAllowBasicClientAuthorization()) && this.tokenService.isBasicAuthToken(authorization)) {
            String password;
            String clientId;
            this.log.debug("Trying to perform basic client authorization ...");
            String encodedCredentials = this.tokenService.getBasicToken(authorization);
            String token = new String(Base64.decodeBase64((String)encodedCredentials), StandardCharsets.UTF_8);
            int delim = token.indexOf(":");
            if (delim != -1 && this.clientService.authenticate(clientId = URLDecoder.decode(token.substring(0, delim), StandardCharsets.UTF_8), password = URLDecoder.decode(token.substring(delim + 1), StandardCharsets.UTF_8))) {
                this.log.debug("Authorized with basic client authentication successfully. client_id: {}", (Object)clientId);
                Client client = this.clientService.getClient(clientId);
                List<String> clientScopes = this.scopeService.getScopeIdsByDns(client.getScopes() != null ? Arrays.asList(client.getScopes()) : new ArrayList());
                if (clientScopes.contains(ACCESS_EVALUATION_SCOPE)) {
                    this.log.debug("Granted access to /evaluation endpoint. Client {} has scope {}.", (Object)clientId, (Object)ACCESS_EVALUATION_SCOPE);
                    return;
                }
                this.log.debug("Access denied to /evaluation endpoint. Client {} has no scope {}.", (Object)clientId, (Object)ACCESS_EVALUATION_SCOPE);
            }
            this.log.debug("Unable to perform basic client authorization.");
        }
        String msg = "Authorization is not valid. Please provide valid authorization in 'Authorization' header.";
        this.log.error("Authorization is not valid. Please provide valid authorization in 'Authorization' header.");
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.UNAUTHORIZED).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)"Authorization is not valid. Please provide valid authorization in 'Authorization' header.").build());
    }
}

