/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.filter;

import io.jans.as.common.model.registration.Client;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.server.filter.CorsFilterConfig;
import io.jans.as.server.model.config.ConfigurationFactory;
import io.jans.as.server.service.ClientService;
import io.jans.server.filters.AbstractCorsFilter;
import io.jans.util.StringHelper;
import jakarta.inject.Inject;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.annotation.WebFilter;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;

@WebFilter(filterName="CorsFilter", asyncSupported=true, urlPatterns={"/.well-known/*", "/restv1/*", "/opiframe"})
public class CorsFilter
extends AbstractCorsFilter {
    @Inject
    private Logger log;
    @Inject
    private ConfigurationFactory configurationFactory;
    @Inject
    private ClientService clientService;
    private boolean filterEnabled;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.parseAndStore("*", "GET,POST,HEAD,OPTIONS", "Origin,Accept,X-Requested-With,Content-Type,Access-Control-Request-Method,Access-Control-Request-Headers", "", "true", "1800", "true");
        AppConfiguration appConfiguration = this.configurationFactory.getAppConfiguration();
        if (filterConfig != null) {
            String filterName = filterConfig.getFilterName();
            CorsFilterConfig corsFilterConfig = new CorsFilterConfig(filterName, appConfiguration);
            String configEnabled = corsFilterConfig.getInitParameter("cors.enabled");
            String configAllowedOrigins = corsFilterConfig.getInitParameter("cors.allowed.origins");
            String configAllowedHttpMethods = corsFilterConfig.getInitParameter("cors.allowed.methods");
            String configAllowedHttpHeaders = corsFilterConfig.getInitParameter("cors.allowed.headers");
            String configExposedHeaders = corsFilterConfig.getInitParameter("cors.exposed.headers");
            String configSupportsCredentials = corsFilterConfig.getInitParameter("cors.support.credentials");
            String configPreflightMaxAge = corsFilterConfig.getInitParameter("cors.preflight.maxage");
            String configDecorateRequest = corsFilterConfig.getInitParameter("cors.request.decorate");
            if (configEnabled != null) {
                this.filterEnabled = Boolean.parseBoolean(configEnabled);
            }
            this.parseAndStore(configAllowedOrigins, configAllowedHttpMethods, configAllowedHttpHeaders, configExposedHeaders, configSupportsCredentials, configPreflightMaxAge, configDecorateRequest);
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (this.filterEnabled) {
            try {
                Collection<String> clientAllowedOrigins = this.doFilterImpl(servletRequest);
                this.setContextClientAllowedOrigins(servletRequest, clientAllowedOrigins);
            }
            catch (Exception ex) {
                this.log.error("Failed to process request", (Throwable)ex);
            }
            super.doFilter(servletRequest, servletResponse, filterChain);
        } else {
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }

    protected Collection<String> doFilterImpl(ServletRequest servletRequest) throws IOException, ServletException {
        List<String> clientAuthorizedOrigins = null;
        if (StringHelper.isNotEmpty((String)servletRequest.getParameter("client_id"))) {
            String[] authorizedOriginsArray;
            String clientId = servletRequest.getParameter("client_id");
            Client client = this.clientService.getClient(clientId);
            if (client != null && (authorizedOriginsArray = client.getAuthorizedOrigins()) != null && authorizedOriginsArray.length > 0) {
                clientAuthorizedOrigins = Arrays.asList(authorizedOriginsArray);
            }
        } else {
            HttpServletRequest httpRequest = (HttpServletRequest)servletRequest;
            String header = httpRequest.getHeader("Authorization");
            if (httpRequest.getRequestURI().endsWith("/token") && header != null && header.startsWith("Basic ")) {
                String[] authorizedOriginsArray;
                Client client;
                String base64Token = header.substring(6);
                String token = new String(Base64.decodeBase64((String)base64Token), StandardCharsets.UTF_8);
                String username = "";
                int delim = token.indexOf(":");
                if (delim != -1) {
                    username = URLDecoder.decode(token.substring(0, delim), "UTF-8");
                }
                if ((client = this.clientService.getClient(username)) != null && (authorizedOriginsArray = client.getAuthorizedOrigins()) != null && authorizedOriginsArray.length > 0) {
                    clientAuthorizedOrigins = Arrays.asList(authorizedOriginsArray);
                }
            }
        }
        return clientAuthorizedOrigins;
    }
}

