/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.i18n;

import io.jans.as.model.configuration.AppConfiguration;
import io.jans.service.cdi.event.ConfigurationUpdate;
import io.jans.util.StringHelper;
import io.jans.util.ilocale.LocaleUtil;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Observes;
import jakarta.faces.context.FacesContext;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.util.Strings;
import org.slf4j.Logger;

@Named(value="language")
@ApplicationScoped
public class LanguageBean
implements Serializable {
    private static final long serialVersionUID = -6723715664277907737L;
    private static final String COOKIE_NAME = "org.gluu.i18n.Locale";
    private static final int DEFAULT_MAX_AGE = 31536000;
    private static final String COOKIE_PATH = "/";
    private static final Locale defaultLocale = Locale.ENGLISH;
    @Inject
    private Logger log;
    private List<Locale> supportedLocales;

    public void initSupportedLocales(@Observes @ConfigurationUpdate AppConfiguration appConfiguration) {
        this.supportedLocales = this.buildSupportedLocales(appConfiguration);
    }

    @Deprecated
    public String getLocaleCode() {
        try {
            Locale locale = this.getCookieLocale();
            if (locale != null) {
                this.setLocale(locale);
                return locale.toLanguageTag();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultLocale.getLanguage();
    }

    public void setLocaleCode(String requestedLocaleCode) {
        for (Locale supportedLocale : this.supportedLocales) {
            if (Strings.isEmpty((CharSequence)supportedLocale.getLanguage()) || !supportedLocale.getLanguage().equals(requestedLocaleCode)) continue;
            Locale locale = new Locale(requestedLocaleCode);
            FacesContext.getCurrentInstance().getViewRoot().setLocale(locale);
            this.setCookieValue(locale.toLanguageTag());
            break;
        }
    }

    public Locale getLocale() {
        try {
            Locale locale = FacesContext.getCurrentInstance().getViewRoot().getLocale();
            if (locale != null) {
                return locale;
            }
        }
        catch (Exception ex) {
            this.log.trace("Failed to get locale from cookie", (Throwable)ex);
        }
        return defaultLocale;
    }

    public void setLocale(Locale requestedLocale) {
        for (Locale supportedLocale : this.supportedLocales) {
            if (!supportedLocale.equals(requestedLocale)) continue;
            FacesContext.getCurrentInstance().getViewRoot().setLocale(supportedLocale);
            this.setCookieValue(supportedLocale.toLanguageTag());
            break;
        }
        this.setLocaleCode(requestedLocale.getLanguage());
    }

    public List<Locale> getSupportedLocales() {
        return this.supportedLocales;
    }

    private List<Locale> buildSupportedLocales(AppConfiguration appConfiguration) {
        List uiLocales = appConfiguration.getUiLocalesSupported();
        LinkedList<Locale> supportedLocales = new LinkedList<Locale>();
        for (String uiLocale : uiLocales) {
            Pair locales = LocaleUtil.toLocaleList((String)uiLocale);
            supportedLocales.addAll((Collection)locales.getRight());
        }
        return supportedLocales;
    }

    public String getMessage(String key) {
        Object result;
        FacesContext context = FacesContext.getCurrentInstance();
        ResourceBundle bundle = context.getApplication().getResourceBundle(context, "msgs");
        try {
            result = bundle.getString(key);
        }
        catch (MissingResourceException e) {
            result = "???" + key + "??? not found";
        }
        return result;
    }

    private String getCookieValue() {
        Cookie cookie = this.getCookie();
        return cookie == null ? null : cookie.getValue();
    }

    private void setCookieValue(String value) {
        FacesContext ctx = FacesContext.getCurrentInstance();
        if (ctx == null) {
            return;
        }
        HttpServletResponse response = (HttpServletResponse)ctx.getExternalContext().getResponse();
        Cookie cookie = new Cookie(COOKIE_NAME, value);
        cookie.setMaxAge(31536000);
        cookie.setPath(COOKIE_PATH);
        cookie.setSecure(true);
        cookie.setVersion(1);
        response.addCookie(cookie);
    }

    @Deprecated
    private Locale getCookieLocale() {
        String cookieValue = this.getCookieValue();
        if (StringHelper.isEmpty((String)cookieValue)) {
            return null;
        }
        return Locale.forLanguageTag(cookieValue);
    }

    private Cookie getCookie() {
        FacesContext ctx = FacesContext.getCurrentInstance();
        if (ctx != null) {
            return (Cookie)ctx.getExternalContext().getRequestCookieMap().get(COOKIE_NAME);
        }
        return null;
    }
}

