/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.model.authorize;

import com.google.common.collect.Sets;
import io.jans.as.common.model.registration.Client;
import io.jans.as.server.service.ScopeService;
import io.jans.as.server.service.SpontaneousScopeService;
import io.jans.as.server.service.external.ExternalSpontaneousScopeService;
import io.jans.as.server.service.external.context.SpontaneousScopeExternalContext;
import jakarta.ejb.Stateless;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

@Stateless
@Named(value="scopeChecker")
public class ScopeChecker {
    @Inject
    private Logger log;
    @Inject
    private ScopeService scopeService;
    @Inject
    private SpontaneousScopeService spontaneousScopeService;
    @Inject
    private ExternalSpontaneousScopeService externalSpontaneousScopeService;

    public Set<String> checkScopesPolicy(Client client, String scope) {
        if (StringUtils.isBlank((CharSequence)scope)) {
            return Sets.newHashSet();
        }
        return this.checkScopesPolicy(client, Arrays.asList(scope.split(" ")));
    }

    public Set<String> checkScopesPolicy(Client client, List<String> scopesRequested) {
        this.log.debug("Checking scopes policy for: " + scopesRequested);
        HashSet<String> grantedScopes = new HashSet<String>();
        if (scopesRequested == null || scopesRequested.isEmpty() || client == null) {
            this.log.debug("No scopes requested or otherwise client is null. ScopesRequested: " + scopesRequested);
            return grantedScopes;
        }
        String[] scopesAllowed = client.getScopes() != null ? client.getScopes() : new String[]{};
        for (String scopeRequested : scopesRequested) {
            if (StringUtils.isBlank((CharSequence)scopeRequested)) continue;
            List<String> scopesAllowedIds = this.scopeService.getScopeIdsByDns(Arrays.asList(scopesAllowed));
            if (scopesAllowedIds.contains(scopeRequested)) {
                grantedScopes.add(scopeRequested);
                continue;
            }
            if (!this.spontaneousScopeService.isAllowedBySpontaneousScopes(client, scopeRequested)) continue;
            grantedScopes.add(scopeRequested);
            SpontaneousScopeExternalContext context = new SpontaneousScopeExternalContext(client, scopeRequested, grantedScopes, this.spontaneousScopeService);
            this.externalSpontaneousScopeService.executeExternalManipulateScope(context);
            if (!context.isAllowSpontaneousScopePersistence()) continue;
            this.spontaneousScopeService.createSpontaneousScopeIfNeeded(Sets.newHashSet((Iterable)client.getAttributes().getSpontaneousScopes()), scopeRequested, client.getClientId());
        }
        this.log.debug("Granted scopes: " + grantedScopes);
        return grantedScopes;
    }
}

