/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.model.token;

import io.jans.as.common.model.registration.Client;
import io.jans.as.common.util.CommonUtils;
import io.jans.as.model.config.WebKeysConfiguration;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.model.crypto.AbstractCryptoProvider;
import io.jans.as.model.crypto.encryption.BlockEncryptionAlgorithm;
import io.jans.as.model.crypto.encryption.KeyEncryptionAlgorithm;
import io.jans.as.model.exception.InvalidJweException;
import io.jans.as.model.jwe.Jwe;
import io.jans.as.model.jwe.JweEncrypterImpl;
import io.jans.as.model.jwk.Algorithm;
import io.jans.as.model.jwk.JSONWebKeySet;
import io.jans.as.model.jwk.KeyOpsType;
import io.jans.as.model.jwk.Use;
import io.jans.as.model.jwt.Jwt;
import io.jans.as.model.jwt.JwtType;
import io.jans.as.model.token.JsonWebResponse;
import io.jans.as.server.model.common.IAuthorizationGrant;
import io.jans.as.server.model.token.JwtSigner;
import io.jans.as.server.service.ClientService;
import io.jans.as.server.service.SectorIdentifierService;
import io.jans.as.server.service.ServerCryptoProvider;
import jakarta.ejb.Stateless;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.nio.charset.StandardCharsets;
import java.security.PublicKey;
import java.util.function.Function;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;
import org.slf4j.Logger;

@Stateless
@Named
public class JwrService {
    @Inject
    private Logger log;
    @Inject
    private AbstractCryptoProvider cryptoProvider;
    @Inject
    private ClientService clientService;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private WebKeysConfiguration webKeysConfiguration;
    @Inject
    private SectorIdentifierService sectorIdentifierService;

    public JsonWebResponse encode(JsonWebResponse jwr, Client client) throws Exception {
        if (jwr instanceof Jwe) {
            return this.encryptJwe((Jwe)jwr, client);
        }
        if (jwr instanceof Jwt) {
            return this.signJwt((Jwt)jwr, client);
        }
        throw new IllegalArgumentException("Unknown Jwr instance.");
    }

    private Jwt signJwt(Jwt jwt, Client client) throws Exception {
        JwtSigner jwtSigner = JwtSigner.newJwtSigner(this.appConfiguration, (JSONWebKeySet)this.webKeysConfiguration, client);
        jwtSigner.setJwt(jwt);
        jwtSigner.sign();
        return jwt;
    }

    private Jwe encryptJwe(Jwe jwe, Client client) throws Exception {
        if (BooleanUtils.isTrue((Boolean)this.appConfiguration.isUseNestedJwtDuringEncryption())) {
            JwtSigner jwtSigner = JwtSigner.newJwtSigner(this.appConfiguration, (JSONWebKeySet)this.webKeysConfiguration, client);
            Jwt jwt = jwtSigner.newJwt();
            jwt.setClaims(jwe.getClaims());
            jwe.setSignedJWTPayload(this.signJwt(jwt, client));
        }
        KeyEncryptionAlgorithm keyEncryptionAlgorithm = KeyEncryptionAlgorithm.fromName((String)jwe.getHeader().getClaimAsString("alg"));
        BlockEncryptionAlgorithm encryptionMethod = jwe.getHeader().getEncryptionMethod();
        if (keyEncryptionAlgorithm == KeyEncryptionAlgorithm.RSA_OAEP || keyEncryptionAlgorithm == KeyEncryptionAlgorithm.RSA1_5) {
            JSONObject jsonWebKeys = CommonUtils.getJwks((Client)client);
            String keyId = new ServerCryptoProvider(this.cryptoProvider).getKeyId(JSONWebKeySet.fromJSONObject((JSONObject)jsonWebKeys), Algorithm.fromString((String)keyEncryptionAlgorithm.getName()), Use.ENCRYPTION, KeyOpsType.CONNECT);
            PublicKey publicKey = this.cryptoProvider.getPublicKey(keyId, jsonWebKeys, null);
            jwe.getHeader().setKeyId(keyId);
            if (publicKey == null) {
                throw new InvalidJweException("The public key is not valid");
            }
            JweEncrypterImpl jweEncrypter = new JweEncrypterImpl(keyEncryptionAlgorithm, encryptionMethod, publicKey);
            return jweEncrypter.encrypt(jwe);
        }
        if (keyEncryptionAlgorithm == KeyEncryptionAlgorithm.A128KW || keyEncryptionAlgorithm == KeyEncryptionAlgorithm.A256KW) {
            byte[] sharedSymmetricKey = this.clientService.decryptSecret(client.getClientSecret()).getBytes(StandardCharsets.UTF_8);
            JweEncrypterImpl jweEncrypter = new JweEncrypterImpl(keyEncryptionAlgorithm, encryptionMethod, sharedSymmetricKey);
            return jweEncrypter.encrypt(jwe);
        }
        throw new IllegalArgumentException("Unsupported encryption algorithm: " + keyEncryptionAlgorithm);
    }

    public JsonWebResponse createJwr(Client client) {
        try {
            KeyEncryptionAlgorithm keyEncryptionAlgorithm = KeyEncryptionAlgorithm.fromName((String)client.getIdTokenEncryptedResponseAlg());
            BlockEncryptionAlgorithm blockEncryptionAlgorithm = BlockEncryptionAlgorithm.fromName((String)client.getIdTokenEncryptedResponseEnc());
            if (keyEncryptionAlgorithm != null && blockEncryptionAlgorithm != null) {
                Jwe jwe = new Jwe();
                jwe.getHeader().setType(JwtType.JWT);
                jwe.getHeader().setAlgorithm(keyEncryptionAlgorithm);
                jwe.getHeader().setEncryptionMethod(blockEncryptionAlgorithm);
                return jwe;
            }
            JwtSigner jwtSigner = JwtSigner.newJwtSigner(this.appConfiguration, (JSONWebKeySet)this.webKeysConfiguration, client);
            return jwtSigner.newJwt();
        }
        catch (Exception e) {
            this.log.error("Failed to create token.", (Throwable)e);
            return null;
        }
    }

    public void setSubjectIdentifier(JsonWebResponse jwr, IAuthorizationGrant authorizationGrant) {
        jwr.getClaims().setSubjectIdentifier(authorizationGrant.getSub());
    }

    public static Function<JsonWebResponse, Void> wrapWithSidFunction(Function<JsonWebResponse, Void> input, String outsideSid) {
        return jwr -> {
            if (jwr == null) {
                return null;
            }
            if (input != null) {
                input.apply((JsonWebResponse)jwr);
            }
            if (StringUtils.isNotEmpty((CharSequence)outsideSid)) {
                jwr.setClaim("sid", outsideSid);
            }
            return null;
        };
    }
}

