/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.rate;

import io.jans.as.server.rate.CachedBodyHttpServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;

public class RateLimitContext {
    private final HttpServletRequest request;
    private final boolean rateLoggingEnabled;
    private CachedBodyHttpServletRequest cachedRequest;

    public RateLimitContext(HttpServletRequest request, boolean rateLoggingEnabled) {
        this.request = request;
        this.rateLoggingEnabled = rateLoggingEnabled;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public boolean isRateLoggingEnabled() {
        return this.rateLoggingEnabled;
    }

    public boolean isCachedRequestAvailable() {
        return this.cachedRequest != null;
    }

    public CachedBodyHttpServletRequest getCachedRequest() throws IOException {
        if (this.cachedRequest == null) {
            this.cachedRequest = new CachedBodyHttpServletRequest(this.request);
        }
        return this.cachedRequest;
    }

    public void setCachedRequest(CachedBodyHttpServletRequest cachedRequest) {
        this.cachedRequest = cachedRequest;
    }
}

