/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.rate;

import io.jans.as.server.rate.RateLimitService;
import io.jans.as.server.rate.RateLimitedException;
import jakarta.annotation.Priority;
import jakarta.inject.Inject;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.annotation.WebFilter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

@WebFilter(filterName="RateLimitFilter", asyncSupported=true, urlPatterns={"/restv1/register"}, displayName="RateLimitFilter")
@Priority(value=1000)
public class RateLimitFilter
implements Filter {
    public static final String TOO_MANY_REQUESTS_JSON_ERROR = "{\"error\": \"Too many requests\"}";
    @Inject
    private Logger log;
    @Inject
    private RateLimitService rateLimitService;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        try {
            httpRequest = this.rateLimitService.validateRateLimit(httpRequest);
            chain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
        }
        catch (RateLimitedException e) {
            this.sendTooManyRequestsError(httpResponse);
        }
        catch (IOException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            chain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            this.sendResponse(httpResponse, Response.Status.INTERNAL_SERVER_ERROR, "");
        }
    }

    private void sendTooManyRequestsError(HttpServletResponse servletResponse) {
        this.sendResponse(servletResponse, Response.Status.TOO_MANY_REQUESTS, TOO_MANY_REQUESTS_JSON_ERROR);
    }

    private void sendResponse(HttpServletResponse servletResponse, Response.Status status, String payloadAsJson) {
        this.log.debug("send back response - status: {}, payload: {}", (Object)status.getStatusCode(), (Object)payloadAsJson);
        try (PrintWriter out = servletResponse.getWriter();){
            servletResponse.setStatus(status.getStatusCode());
            if (StringUtils.isNotBlank((CharSequence)payloadAsJson)) {
                servletResponse.setContentType("application/json;charset=UTF-8");
                out.write(payloadAsJson);
            }
        }
        catch (IOException ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
        }
    }

    public void init(FilterConfig filterConfig) {
        this.log.info("Rate Limit Filter initialized.");
    }

    public void destroy() {
        this.log.info("Rate Limit Filter destroyed.");
    }
}

