/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.register.ws.rs.action;

import io.jans.as.common.model.registration.Client;
import io.jans.as.model.common.FeatureFlagType;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.model.error.ErrorResponseFactory;
import io.jans.as.model.error.IErrorType;
import io.jans.as.model.register.RegisterErrorResponseType;
import io.jans.as.server.audit.ApplicationAuditLogger;
import io.jans.as.server.model.audit.Action;
import io.jans.as.server.model.audit.OAuth2AuditLog;
import io.jans.as.server.model.registration.RegisterParamsValidator;
import io.jans.as.server.register.ws.rs.RegisterValidator;
import io.jans.as.server.service.ClientService;
import io.jans.as.server.service.token.TokenService;
import io.jans.as.server.util.ServerUtil;
import jakarta.ejb.Stateless;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;

@Stateless
@Named
public class RegisterDeleteAction {
    @Inject
    private Logger log;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private ClientService clientService;
    @Inject
    private TokenService tokenService;
    @Inject
    private RegisterParamsValidator registerParamsValidator;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private RegisterValidator registerValidator;
    @Inject
    private ApplicationAuditLogger applicationAuditLogger;

    public Response delete(String clientId, String authorization, HttpServletRequest httpRequest, SecurityContext securityContext) {
        OAuth2AuditLog auditLog = new OAuth2AuditLog(ServerUtil.getIpAddress(httpRequest), Action.CLIENT_DELETE);
        auditLog.setClientId(clientId);
        try {
            Client client;
            this.errorResponseFactory.validateFeatureEnabled(FeatureFlagType.REGISTRATION);
            String accessToken = this.tokenService.getToken(authorization);
            this.log.debug("Attempting to delete client: clientId = {}, registrationAccessToken = {} isSecure = {}", new Object[]{clientId, accessToken, securityContext.isSecure()});
            if (!this.registerParamsValidator.validateParamsClientRead(clientId, accessToken)) {
                this.log.trace("Client parameters are invalid.");
                throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)RegisterErrorResponseType.INVALID_CLIENT_METADATA, "");
            }
            if (BooleanUtils.isTrue((Boolean)this.appConfiguration.getDcrAuthorizationWithClientCredentials())) {
                this.registerValidator.validateAuthorizationAccessToken(accessToken, clientId);
            }
            if ((client = this.clientService.getClient(clientId, accessToken)) == null) {
                throw this.errorResponseFactory.createWebApplicationException(Response.Status.UNAUTHORIZED, (IErrorType)RegisterErrorResponseType.INVALID_TOKEN, "");
            }
            this.clientService.remove(client);
            auditLog.setSuccess(true);
            Response response = Response.status((Response.Status)Response.Status.NO_CONTENT).cacheControl(ServerUtil.cacheControl(true, false)).header("Pragma", (Object)"no-cache").build();
            return response;
        }
        catch (WebApplicationException e) {
            if (e.getResponse() != null) {
                Response response = e.getResponse();
                return response;
            }
            throw e;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR, (IErrorType)RegisterErrorResponseType.INVALID_CLIENT_METADATA, "Failed to process request.");
        }
        finally {
            this.applicationAuditLogger.sendMessage(auditLog);
        }
    }
}

