/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.register.ws.rs.action;

import io.jans.as.common.model.registration.Client;
import io.jans.as.model.common.FeatureFlagType;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.model.error.ErrorResponseFactory;
import io.jans.as.model.error.IErrorType;
import io.jans.as.model.register.RegisterErrorResponseType;
import io.jans.as.server.audit.ApplicationAuditLogger;
import io.jans.as.server.model.audit.Action;
import io.jans.as.server.model.audit.OAuth2AuditLog;
import io.jans.as.server.model.common.ExecutionContext;
import io.jans.as.server.model.registration.RegisterParamsValidator;
import io.jans.as.server.register.ws.rs.RegisterJsonService;
import io.jans.as.server.register.ws.rs.RegisterService;
import io.jans.as.server.register.ws.rs.RegisterValidator;
import io.jans.as.server.service.ClientService;
import io.jans.as.server.service.external.ExternalDynamicClientRegistrationService;
import io.jans.as.server.service.token.TokenService;
import io.jans.as.server.util.ServerUtil;
import io.jans.util.security.StringEncrypter;
import jakarta.ejb.Stateless;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import org.apache.commons.lang3.BooleanUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;

@Stateless
@Named
public class RegisterReadAction {
    @Inject
    private Logger log;
    @Inject
    private ApplicationAuditLogger applicationAuditLogger;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private ClientService clientService;
    @Inject
    private TokenService tokenService;
    @Inject
    private ExternalDynamicClientRegistrationService externalDynamicClientRegistrationService;
    @Inject
    private RegisterParamsValidator registerParamsValidator;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private RegisterValidator registerValidator;
    @Inject
    private RegisterService registerService;
    @Inject
    private RegisterJsonService registerJsonService;

    public Response readClient(String clientId, String authorization, HttpServletRequest httpRequest, SecurityContext securityContext) {
        OAuth2AuditLog oAuth2AuditLog;
        Response.ResponseBuilder builder;
        block7: {
            String accessToken = this.tokenService.getToken(authorization);
            this.log.debug("Attempting to read client: clientId = {}, registrationAccessToken = {} isSecure = {}", new Object[]{clientId, accessToken, securityContext.isSecure()});
            this.errorResponseFactory.validateFeatureEnabled(FeatureFlagType.REGISTRATION);
            builder = Response.ok();
            oAuth2AuditLog = new OAuth2AuditLog(ServerUtil.getIpAddress(httpRequest), Action.CLIENT_READ);
            oAuth2AuditLog.setClientId(clientId);
            try {
                if (this.registerParamsValidator.validateParamsClientRead(clientId, accessToken)) {
                    Client client;
                    if (BooleanUtils.isTrue((Boolean)this.appConfiguration.getDcrAuthorizationWithClientCredentials())) {
                        this.registerValidator.validateAuthorizationAccessToken(accessToken, clientId);
                    }
                    if ((client = this.clientService.getClient(clientId, accessToken)) != null) {
                        oAuth2AuditLog.setScope(this.registerService.clientScopesToString(client));
                        oAuth2AuditLog.setSuccess(true);
                        JSONObject jsonObject = this.registerJsonService.getJSONObject(client);
                        jsonObject = this.modifyReadScript(jsonObject, new ExecutionContext(httpRequest, null).setClient(client));
                        builder.entity((Object)this.registerJsonService.jsonObjectToString(jsonObject));
                    } else {
                        this.log.trace("The Access Token is not valid for the Client ID, returns invalid_token error.");
                        builder = Response.status((int)Response.Status.UNAUTHORIZED.getStatusCode()).type(MediaType.APPLICATION_JSON_TYPE);
                        builder.entity((Object)this.errorResponseFactory.errorAsJson((IErrorType)RegisterErrorResponseType.INVALID_TOKEN, "The Access Token is not valid for the Client"));
                    }
                    break block7;
                }
                this.log.trace("Client ID or Access Token is not valid.");
                throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)RegisterErrorResponseType.INVALID_CLIENT_METADATA, "Client ID or Access Token is not valid.");
            }
            catch (JSONException e) {
                this.log.error(e.getMessage(), (Throwable)e);
                throw this.errorResponseFactory.createWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR, (IErrorType)RegisterErrorResponseType.INVALID_CLIENT_METADATA, "Failed to parse json.");
            }
            catch (StringEncrypter.EncryptionException e) {
                this.log.error(e.getMessage(), (Throwable)e);
                throw this.errorResponseFactory.createWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR, (IErrorType)RegisterErrorResponseType.INVALID_CLIENT_METADATA, "Encryption exception occurred.");
            }
        }
        builder.cacheControl(ServerUtil.cacheControl(true, false));
        builder.header("Pragma", (Object)"no-cache");
        this.applicationAuditLogger.sendMessage(oAuth2AuditLog);
        return builder.build();
    }

    private JSONObject modifyReadScript(JSONObject jsonObject, ExecutionContext executionContext) throws StringEncrypter.EncryptionException {
        if (!this.externalDynamicClientRegistrationService.modifyReadResponse(jsonObject, executionContext)) {
            return this.registerJsonService.getJSONObject(executionContext.getClient());
        }
        return jsonObject;
    }
}

