/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.revoke;

import io.jans.as.common.model.registration.Client;
import io.jans.as.model.common.FeatureFlagType;
import io.jans.as.model.common.TokenTypeHint;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.model.error.ErrorResponseFactory;
import io.jans.as.model.error.IErrorType;
import io.jans.as.model.token.TokenRevocationErrorResponseType;
import io.jans.as.server.audit.ApplicationAuditLogger;
import io.jans.as.server.model.audit.Action;
import io.jans.as.server.model.audit.OAuth2AuditLog;
import io.jans.as.server.model.common.AuthorizationGrant;
import io.jans.as.server.model.common.AuthorizationGrantList;
import io.jans.as.server.model.common.ExecutionContext;
import io.jans.as.server.model.session.SessionClient;
import io.jans.as.server.revoke.RevokeRestWebService;
import io.jans.as.server.security.Identity;
import io.jans.as.server.service.ClientService;
import io.jans.as.server.service.GrantService;
import io.jans.as.server.service.external.ExternalRevokeTokenService;
import io.jans.as.server.util.ServerUtil;
import io.jans.model.token.TokenEntity;
import io.jans.model.token.TokenType;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

@Path(value="/")
public class RevokeRestWebServiceImpl
implements RevokeRestWebService {
    @Inject
    private Logger log;
    @Inject
    private ApplicationAuditLogger applicationAuditLogger;
    @Inject
    private Identity identity;
    @Inject
    private AuthorizationGrantList authorizationGrantList;
    @Inject
    private GrantService grantService;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private ClientService clientService;
    @Inject
    private ExternalRevokeTokenService externalRevokeTokenService;
    @Inject
    private AppConfiguration appConfiguration;

    @Override
    public Response requestAccessToken(String tokenString, String tokenTypeHint, String clientId, HttpServletRequest request, HttpServletResponse response, SecurityContext sec) {
        boolean isAll;
        Client client;
        this.log.debug("Attempting to revoke token: token = {}, tokenTypeHint = {}, isSecure = {}", new Object[]{tokenString, tokenTypeHint, sec.isSecure()});
        this.errorResponseFactory.validateFeatureEnabled(FeatureFlagType.REVOKE_TOKEN);
        OAuth2AuditLog oAuth2AuditLog = new OAuth2AuditLog(ServerUtil.getIpAddress(request), Action.TOKEN_REVOCATION);
        this.validateToken(tokenString);
        Response.ResponseBuilder builder = Response.ok();
        SessionClient sessionClient = this.identity.getSessionClient();
        Client client2 = client = sessionClient != null ? sessionClient.getClient() : null;
        if (client == null && !this.clientService.isPublic(client = this.clientService.getClient(clientId))) {
            this.log.trace("Client is not public and not authenticated. Skip revoking.");
            return this.response(builder, oAuth2AuditLog);
        }
        if (client == null) {
            this.log.trace("Client is not unknown. Skip revoking.");
            return this.response(builder, oAuth2AuditLog);
        }
        oAuth2AuditLog.setClientId(client.getClientId());
        ExecutionContext executionContext = new ExecutionContext(request, response);
        executionContext.setClient(client);
        executionContext.setResponseBuilder(builder);
        boolean scriptResult = this.externalRevokeTokenService.revokeTokenMethods(executionContext);
        if (!scriptResult) {
            this.log.trace("Revoke is forbidden by 'Revoke Token' custom script (method returned false). Exit without revoking.");
            return this.response(builder, oAuth2AuditLog);
        }
        TokenTypeHint tth = TokenTypeHint.getByValue((String)tokenTypeHint);
        boolean bl = isAll = "all".equalsIgnoreCase(tokenString) && this.appConfiguration.getAllowAllValueForRevokeEndpoint() != false;
        if (isAll) {
            this.removeAllTokens(tth, executionContext);
            return this.response(builder, oAuth2AuditLog);
        }
        Object[] tokens = tokenString.split(" ");
        if (ArrayUtils.isEmpty((Object[])tokens)) {
            throw new WebApplicationException(Response.status((int)Response.Status.BAD_REQUEST.getStatusCode()).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)this.errorResponseFactory.errorAsJson((IErrorType)TokenRevocationErrorResponseType.INVALID_REQUEST, "Failed to validate token")).build());
        }
        for (Object token : tokens) {
            this.removeToken((String)token, executionContext, tth);
        }
        return this.response(builder, oAuth2AuditLog);
    }

    private void removeToken(String token, ExecutionContext executionContext, TokenTypeHint tth) {
        Client client = executionContext.getClient();
        AuthorizationGrant authorizationGrant = this.findAuthorizationGrant(token, tth);
        if (this.log.isTraceEnabled()) {
            String msg = authorizationGrant != null ? authorizationGrant.getGrantId() : "not";
            this.log.trace("Grant {} found for token {}", (Object)msg, (Object)token);
        }
        if (authorizationGrant == null) {
            this.log.trace("Unable to find grant for token {}", (Object)token);
            return;
        }
        this.validateSameClient(authorizationGrant, client);
        this.validateScope(authorizationGrant, client);
        this.grantService.removeAllByGrantId(authorizationGrant.getGrantId());
        this.log.trace("Revoked successfully token {}", (Object)token);
    }

    public void validateScope(AuthorizationGrant authorizationGrant, Client client) {
        if (authorizationGrant.getClientId().equals(client.getClientId())) {
            return;
        }
        if (client.getScopes() != null && Arrays.asList(client.getScopes()).contains("revoke_any_token")) {
            return;
        }
        this.log.trace("Client {} does not have 'revoke_any_token' scope which is required to be able revoke other client's tokens", (Object)client.getClientId());
        throw new WebApplicationException(Response.status((int)Response.Status.BAD_REQUEST.getStatusCode()).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)this.errorResponseFactory.errorAsJson((IErrorType)TokenRevocationErrorResponseType.INVALID_REQUEST, "Client does not have 'revoke_any_token' scope")).build());
    }

    public void validateSameClient(AuthorizationGrant grant, Client client) {
        if (!grant.getClientId().equals(client.getClientId()) && BooleanUtils.isFalse((Boolean)this.appConfiguration.getAllowRevokeForOtherClients())) {
            this.log.trace("Token was issued with client {} but revoke is requested with client {}. Skip revoking.", (Object)grant.getClientId(), (Object)client.getClientId());
            throw new WebApplicationException(Response.status((int)Response.Status.BAD_REQUEST.getStatusCode()).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)this.errorResponseFactory.errorAsJson((IErrorType)TokenRevocationErrorResponseType.INVALID_REQUEST, "Failed to validate token.")).build());
        }
    }

    private void removeAllTokens(TokenTypeHint tth, ExecutionContext executionContext) {
        String clientId = executionContext.getClient().getClientId();
        List<TokenEntity> tokens = this.grantService.getGrantsOfClient(clientId);
        this.log.debug("Revoking all tokens of client {}...", (Object)clientId);
        ArrayList<TokenEntity> tokensToRemove = new ArrayList<TokenEntity>();
        for (TokenEntity token : tokens) {
            if (!(tth == null || tth == TokenTypeHint.ACCESS_TOKEN && token.getTokenTypeEnum() == TokenType.ACCESS_TOKEN || tth == TokenTypeHint.TX_TOKEN && token.getTokenTypeEnum() == TokenType.TX_TOKEN || tth == TokenTypeHint.LOGOUT_STATUS_JWT && token.getTokenTypeEnum() == TokenType.LOGOUT_STATUS_JWT) && (tth != TokenTypeHint.REFRESH_TOKEN || token.getTokenTypeEnum() != TokenType.REFRESH_TOKEN)) continue;
            tokensToRemove.add(token);
        }
        this.grantService.removeSilently(tokensToRemove);
        this.log.debug("Revoked all tokens of client {}.", (Object)clientId);
    }

    private AuthorizationGrant findAuthorizationGrant(String token, TokenTypeHint tth) {
        if (tth == TokenTypeHint.ACCESS_TOKEN || tth == TokenTypeHint.TX_TOKEN) {
            return this.authorizationGrantList.getAuthorizationGrantByAccessToken(token);
        }
        if (tth == TokenTypeHint.JTI) {
            return this.authorizationGrantList.getAuthorizationGrantByJti(token);
        }
        TokenEntity grantByCode = this.grantService.getGrantByCode(token);
        return this.authorizationGrantList.asGrant(grantByCode);
    }

    private void validateToken(String token) {
        if (StringUtils.isBlank((CharSequence)token)) {
            throw new WebApplicationException(Response.status((int)Response.Status.BAD_REQUEST.getStatusCode()).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)this.errorResponseFactory.errorAsJson((IErrorType)TokenRevocationErrorResponseType.INVALID_REQUEST, "Failed to validate token.")).build());
        }
    }

    private Response response(Response.ResponseBuilder builder, OAuth2AuditLog oAuth2AuditLog) {
        builder.cacheControl(ServerUtil.cacheControl(true, false));
        builder.header("Pragma", (Object)"no-cache");
        this.applicationAuditLogger.sendMessage(oAuth2AuditLog);
        return builder.build();
    }
}

