/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.service;

import io.jans.as.common.model.registration.Client;
import io.jans.as.common.model.session.SessionId;
import io.jans.as.common.model.session.SessionIdState;
import io.jans.as.model.authorize.AuthorizeErrorResponseType;
import io.jans.as.model.common.Prompt;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.model.error.IErrorType;
import io.jans.as.model.util.StringUtils;
import io.jans.as.model.util.Util;
import io.jans.as.server.authorize.ws.rs.AuthzRequest;
import io.jans.as.server.model.exception.AcrChangedException;
import io.jans.as.server.security.Identity;
import io.jans.as.server.service.SessionIdService;
import io.jans.as.server.service.external.ExternalAuthenticationService;
import io.jans.as.server.service.external.session.SessionEvent;
import io.jans.as.server.service.external.session.SessionEventType;
import io.jans.model.AuthenticationScriptUsageType;
import io.jans.model.custom.script.conf.CustomScriptConfiguration;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.List;
import java.util.Map;
import org.python.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class AcrService {
    private static final Logger log = LoggerFactory.getLogger(AcrService.class);
    public static final String AGAMA = "agama";
    @Inject
    private Identity identity;
    @Inject
    private SessionIdService sessionIdService;
    @Inject
    private ExternalAuthenticationService externalAuthenticationService;
    @Inject
    private AppConfiguration appConfiguration;

    public static boolean isAgama(String acr) {
        return org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)acr) && (acr.startsWith("agama_") || AGAMA.equalsIgnoreCase(acr));
    }

    public static String getScriptName(String acr) {
        return AcrService.isAgama(acr) ? AGAMA : acr;
    }

    public void validateAcrs(AuthzRequest authzRequest, Client client) throws AcrChangedException {
        this.applyAcrMappings(authzRequest);
        this.checkClientAuthorizedAcrs(authzRequest, client);
        this.checkAcrScriptIsAvailable(authzRequest);
        this.checkAcrChanged(authzRequest, this.identity.getSessionId());
    }

    public static void removeParametersForAgamaAcr(AuthzRequest authzRequest) {
        List<String> acrValues = authzRequest.getAcrValuesList();
        for (int i = 0; i < acrValues.size(); ++i) {
            String acr = acrValues.get(i);
            acrValues.set(i, AcrService.removeParametersFromAgamaAcr(acr));
        }
        String result = StringUtils.implode(acrValues, (String)" ");
        authzRequest.setAcrValues(result);
    }

    public static String removeParametersFromAgamaAcr(String acr) {
        if (AcrService.isAgama(acr)) {
            return org.apache.commons.lang3.StringUtils.substringBefore((String)acr, (String)"-");
        }
        return acr;
    }

    public void checkClientAuthorizedAcrs(AuthzRequest authzRequest, Client client) {
        List authorizedAcrs = client.getAttributes().getAuthorizedAcrValues();
        if (authorizedAcrs.isEmpty()) {
            return;
        }
        String mappedAuthorizedAcrs = this.applyAcrMappings(authorizedAcrs);
        for (String acr : authzRequest.getAcrValuesList()) {
            if (authorizedAcrs.contains(acr) || mappedAuthorizedAcrs.contains(acr)) continue;
            throw authzRequest.getRedirectUriResponse().createWebException((IErrorType)AuthorizeErrorResponseType.INVALID_REQUEST, "Restricted acr value request, please review the list of authorized acr values for this client");
        }
    }

    public void applyAcrMappings(AuthzRequest authzRequest) {
        this.applyAcrMappings(authzRequest, this.appConfiguration);
    }

    public void applyAcrMappings(AuthzRequest authzRequest, AppConfiguration appConfiguration) {
        List<String> acrValues = authzRequest.getAcrValuesList();
        log.debug("ACR values before mapping: {}", acrValues);
        String result = this.applyAcrMappings(acrValues, appConfiguration);
        log.debug("ACR values after mapping: {}", (Object)result);
        authzRequest.setAcrValues(result);
    }

    public String applyAcrMappings(List<String> acrValues) {
        return this.applyAcrMappings(acrValues, this.appConfiguration);
    }

    public String applyAcrMappings(List<String> acrValues, AppConfiguration appConfiguration) {
        Map mappings = appConfiguration.getAcrMappings();
        if (acrValues == null || acrValues.isEmpty()) {
            return "";
        }
        if (mappings == null || mappings.isEmpty()) {
            return StringUtils.implode(acrValues, (String)" ");
        }
        boolean updated = false;
        for (int i = 0; i < acrValues.size(); ++i) {
            String acr = acrValues.get(i);
            String value = (String)mappings.get(acr);
            if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)value)) continue;
            if (acrValues.contains(value)) {
                log.debug("Found duplicated acr {}", (Object)value);
                value = "";
            }
            log.debug("Replaced acr {} with {}, defined from acrMapping.", (Object)acr, (Object)value);
            acrValues.set(i, value);
            updated = true;
        }
        String result = StringUtils.implode(acrValues, (String)" ").trim();
        if (updated) {
            log.debug("Mapped result: {}", (Object)result);
        }
        return result;
    }

    public void checkAcrScriptIsAvailable(AuthzRequest authzRequest) {
        String acrValues = authzRequest.getAcrValues();
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)acrValues)) {
            return;
        }
        if (Util.isBuiltInPasswordAuthn((String)acrValues)) {
            return;
        }
        List<String> acrsToDetermineScript = AcrService.getAcrsToDetermineScript(authzRequest.getAcrValuesList());
        CustomScriptConfiguration script = this.externalAuthenticationService.determineCustomScriptConfiguration(AuthenticationScriptUsageType.INTERACTIVE, acrsToDetermineScript);
        if (script == null) {
            String msg = String.format("Unable to find script for acr: %s. Send error: %s", acrsToDetermineScript, AuthorizeErrorResponseType.UNMET_AUTHENTICATION_REQUIREMENTS.getParameter());
            log.debug(msg);
            throw authzRequest.getRedirectUriResponse().createWebException((IErrorType)AuthorizeErrorResponseType.UNMET_AUTHENTICATION_REQUIREMENTS, msg);
        }
    }

    public static List<String> getAcrsToDetermineScript(List<String> acrValues) {
        if (acrValues == null || acrValues.isEmpty()) {
            return Lists.newArrayList();
        }
        if (AcrService.isAgama(acrValues.get(0))) {
            return Lists.newArrayList((Object[])new String[]{AGAMA});
        }
        return acrValues;
    }

    private void checkAcrChanged(AuthzRequest authzRequest, SessionId sessionUser) throws AcrChangedException {
        try {
            this.sessionIdService.assertAuthenticatedSessionCorrespondsToNewRequest(sessionUser, authzRequest.getAcrValues());
        }
        catch (AcrChangedException e) {
            if (e.isForceReAuthentication()) {
                if (!authzRequest.getPromptList().contains(Prompt.LOGIN)) {
                    log.info("ACR is changed, adding prompt=login to prompts");
                    authzRequest.addPrompt(Prompt.LOGIN);
                    sessionUser.setState(SessionIdState.UNAUTHENTICATED);
                    sessionUser.getSessionAttributes().put("prompt", authzRequest.getPrompt());
                    if (!this.sessionIdService.persistSessionId(sessionUser, false, true)) {
                        log.trace("Unable persist session_id, trying to update it.");
                        this.sessionIdService.updateSessionId(sessionUser);
                    }
                    this.sessionIdService.externalEvent(new SessionEvent(SessionEventType.UNAUTHENTICATED, sessionUser));
                }
            }
            throw e;
        }
    }
}

