/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.service;

import io.jans.as.common.model.registration.Client;
import io.jans.as.common.model.session.SessionId;
import io.jans.as.model.authorize.AuthorizeErrorResponseType;
import io.jans.as.model.common.GrantType;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.model.error.ErrorResponseFactory;
import io.jans.as.model.error.IErrorType;
import io.jans.as.server.model.common.DeviceAuthorizationCacheControl;
import io.jans.as.server.model.common.DeviceAuthorizationStatus;
import io.jans.as.server.service.SessionIdService;
import io.jans.service.CacheService;
import jakarta.ejb.Stateless;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import java.io.Serializable;
import java.net.URI;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

@Stateless
@Named
public class DeviceAuthorizationService
implements Serializable {
    public static final String SESSION_ATTEMPTS = "attemps";
    public static final String SESSION_LAST_ATTEMPT = "last_attempt";
    public static final String SESSION_USER_CODE = "user_code";
    @Inject
    private Logger log;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private CacheService cacheService;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private SessionIdService sessionIdService;

    public void saveInCache(DeviceAuthorizationCacheControl data, boolean saveDeviceCode, boolean saveUserCode) {
        if (saveDeviceCode) {
            this.cacheService.put(data.getExpiresIn(), data.getDeviceCode(), (Object)data);
        }
        if (saveUserCode) {
            this.cacheService.put(data.getExpiresIn(), data.getUserCode(), (Object)data);
        }
        this.log.trace("Device request saved in cache, userCode: {}, deviceCode: {}, clientId: {}", new Object[]{data.getUserCode(), data.getDeviceCode(), data.getClient().getClientId()});
    }

    public DeviceAuthorizationCacheControl getDeviceAuthzByUserCode(String userCode) {
        Object cachedObject = this.cacheService.get(userCode);
        if (cachedObject == null) {
            cachedObject = this.cacheService.get(userCode);
            this.log.trace("Failed to fetch DeviceAuthorizationCacheControl request from cache, cacheKey: {}", (Object)userCode);
        }
        return cachedObject instanceof DeviceAuthorizationCacheControl ? (DeviceAuthorizationCacheControl)cachedObject : null;
    }

    public DeviceAuthorizationCacheControl getDeviceAuthzByDeviceCode(String deviceCode) {
        Object cachedObject = this.cacheService.get(deviceCode);
        if (cachedObject == null) {
            cachedObject = this.cacheService.get(deviceCode);
            this.log.trace("Failed to fetch DeviceAuthorizationCacheControl request from cache, cacheKey: {}", (Object)deviceCode);
        }
        return cachedObject instanceof DeviceAuthorizationCacheControl ? (DeviceAuthorizationCacheControl)cachedObject : null;
    }

    public boolean hasDeviceCodeCompatibility(Client client) {
        for (GrantType gt : client.getGrantTypes()) {
            if (!gt.getValue().equals(GrantType.DEVICE_CODE.getValue())) continue;
            return true;
        }
        return false;
    }

    public String getDeviceAuthorizationPage(DeviceAuthorizationCacheControl deviceAuthorizationCacheControl, Client client, String state, HttpServletRequest servletRequest) {
        if (deviceAuthorizationCacheControl == null) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)AuthorizeErrorResponseType.INVALID_REQUEST, state, "Request not processed.")).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
        if (deviceAuthorizationCacheControl.getStatus() != DeviceAuthorizationStatus.PENDING) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)AuthorizeErrorResponseType.INVALID_REQUEST, state, "Request already processed.")).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
        if (!deviceAuthorizationCacheControl.getClient().getClientId().equals(client.getClientId())) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)AuthorizeErrorResponseType.UNAUTHORIZED_CLIENT, state, "Client doesn't match.")).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
        URI uri = UriBuilder.fromPath((String)this.appConfiguration.getIssuer()).path(servletRequest.getContextPath()).path("/device_authorization.htm").build(new Object[0]);
        return uri.toString();
    }

    public void removeDeviceAuthRequestInCache(String userCode, String deviceCode) {
        try {
            if (StringUtils.isNotBlank((CharSequence)userCode)) {
                this.cacheService.remove(userCode);
            }
            if (StringUtils.isNotBlank((CharSequence)deviceCode)) {
                this.cacheService.remove(deviceCode);
            }
            this.log.debug("Removed from cache device authorization using user_code: {}, device_code: {}", (Object)userCode, (Object)deviceCode);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }

    public String getUserCodeFromSession(HttpServletRequest httpRequest) {
        Map sessionAttributes;
        SessionId sessionId = this.sessionIdService.getSessionId(httpRequest);
        if (sessionId != null && (sessionAttributes = sessionId.getSessionAttributes()).containsKey(SESSION_USER_CODE)) {
            return (String)sessionAttributes.get(SESSION_USER_CODE);
        }
        return null;
    }
}

