/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.service;

import io.jans.as.model.config.Conf;
import io.jans.as.model.config.WebKeysConfiguration;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.model.crypto.AbstractCryptoProvider;
import io.jans.as.model.jwk.JSONWebKey;
import io.jans.as.server.jwk.ws.rs.ArchivedJwksService;
import io.jans.as.server.model.config.ConfigurationFactory;
import io.jans.as.server.service.cdi.event.KeyGenerationEvent;
import io.jans.as.server.util.ServerUtil;
import io.jans.orm.PersistenceEntryManager;
import io.jans.service.cdi.async.Asynchronous;
import io.jans.service.cdi.event.Scheduled;
import io.jans.service.timer.event.TimerEvent;
import io.jans.service.timer.schedule.TimerSchedule;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Event;
import jakarta.enterprise.event.Observes;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.lang.annotation.Annotation;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;

@ApplicationScoped
@Named
public class KeyGeneratorTimer {
    private static final int DEFAULT_INTERVAL = 60;
    @Inject
    private Logger log;
    @Inject
    private Event<TimerEvent> timerEvent;
    @Inject
    private ConfigurationFactory configurationFactory;
    @Inject
    private PersistenceEntryManager ldapEntryManager;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private AbstractCryptoProvider cryptoProvider;
    @Inject
    private ArchivedJwksService archivedJwksService;
    private AtomicBoolean isActive;
    private long lastFinishedTime;

    public long getLastFinishedTime() {
        return this.lastFinishedTime;
    }

    public void initTimer() {
        this.log.debug("Initializing Key Generator Timer");
        this.isActive = new AtomicBoolean(false);
        this.timerEvent.fire((Object)new TimerEvent(new TimerSchedule(60, 60), (Object)new KeyGenerationEvent(), new Annotation[]{Scheduled.Literal.INSTANCE}));
        this.lastFinishedTime = System.currentTimeMillis();
    }

    @Asynchronous
    public void process(@Observes @Scheduled KeyGenerationEvent keyGenerationEvent) {
        if (!this.appConfiguration.getKeyRegenerationEnabled().booleanValue()) {
            return;
        }
        if (this.isActive.get()) {
            return;
        }
        if (!this.isActive.compareAndSet(false, true)) {
            return;
        }
        try {
            this.updateKeys();
        }
        catch (Exception ex) {
            this.log.error("Exception happened while executing keys update", (Throwable)ex);
        }
        finally {
            this.isActive.set(false);
        }
    }

    private void updateKeys() throws Exception {
        if (!this.isStartUpdateKeys()) {
            return;
        }
        this.updateKeysImpl();
        this.lastFinishedTime = System.currentTimeMillis();
    }

    private boolean isStartUpdateKeys() {
        long poolingInterval = this.appConfiguration.getKeyRegenerationInterval();
        if (poolingInterval <= 0L) {
            poolingInterval = 60L;
        }
        poolingInterval = poolingInterval * 3600L * 1000L;
        long timeDifference = System.currentTimeMillis() - this.lastFinishedTime;
        return timeDifference >= poolingInterval;
    }

    private void updateKeysImpl() throws Exception {
        this.log.info("Updating JWKS keys ...");
        String dn = this.configurationFactory.getBaseConfiguration().getString("jansAuth_ConfigurationEntryDN");
        Conf conf = (Conf)this.ldapEntryManager.find(Conf.class, (Object)dn);
        JSONObject jwks = conf.getWebKeys().toJSONObject();
        JSONObject updatedJwks = this.updateKeys(jwks);
        this.archivedJwksService.archiveRemovedKeys(jwks, updatedJwks);
        conf.setWebKeys((WebKeysConfiguration)ServerUtil.createJsonMapper().readValue(updatedJwks.toString(), WebKeysConfiguration.class));
        long nextRevision = conf.getRevision() + 1L;
        conf.setRevision(nextRevision);
        this.ldapEntryManager.merge((Object)conf);
        this.log.info("Updated JWKS successfully");
        this.log.trace("JWKS keys: {}", conf.getWebKeys().getKeys().stream().map(JSONWebKey::getKid).collect(Collectors.toList()));
        this.log.trace("KeyStore keys: {}", (Object)this.cryptoProvider.getKeys());
    }

    private JSONObject updateKeys(JSONObject jwks) throws Exception {
        JSONObject jsonObject = AbstractCryptoProvider.generateJwks((AbstractCryptoProvider)this.cryptoProvider, (AppConfiguration)this.appConfiguration);
        JSONArray keys = jwks.getJSONArray("keys");
        for (int i = 0; i < keys.length(); ++i) {
            JSONObject key = keys.getJSONObject(i);
            if (key.has("exp") && !key.isNull("exp")) {
                GregorianCalendar now = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
                GregorianCalendar expirationDate = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
                expirationDate.setTimeInMillis(key.getLong("exp"));
                if (expirationDate.before(now)) {
                    this.log.trace("Removing JWK: {}, Expiration date: {}", (Object)key.getString("kid"), (Object)key.getLong("exp"));
                    this.cryptoProvider.deleteKey(key.getString("kid"));
                    continue;
                }
                if (!this.cryptoProvider.containsKey(key.getString("kid"))) continue;
                this.log.trace("Contains kid: {}", (Object)key.getString("kid"));
                jsonObject.getJSONArray("keys").put((Object)key);
                continue;
            }
            if (!this.cryptoProvider.containsKey(key.getString("kid"))) continue;
            GregorianCalendar expirationTime = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
            expirationTime.add(10, this.appConfiguration.getKeyRegenerationInterval());
            expirationTime.add(13, this.appConfiguration.getIdTokenLifetime());
            key.put("exp", expirationTime.getTimeInMillis());
            this.log.trace("Contains kid {} without exp {}", (Object)key.getString("kid"), (Object)expirationTime);
            jsonObject.getJSONArray("keys").put((Object)key);
        }
        return jsonObject;
    }
}

