/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.service;

import io.jans.as.common.service.common.UserService;
import io.jans.as.model.common.PairwiseIdType;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.model.util.SubjectIdentifierGenerator;
import io.jans.as.persistence.model.PairwiseIdentifier;
import io.jans.orm.PersistenceEntryManager;
import io.jans.orm.model.base.SimpleBranch;
import io.jans.orm.search.filter.Filter;
import io.jans.util.StringHelper;
import jakarta.ejb.Stateless;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.List;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;

@Stateless
@Named
public class PairwiseIdentifierService {
    @Inject
    private Logger log;
    @Inject
    private PersistenceEntryManager ldapEntryManager;
    @Inject
    private UserService userService;
    @Inject
    private AppConfiguration appConfiguration;

    public void addBranch(String userInum) {
        SimpleBranch branch = new SimpleBranch();
        branch.setOrganizationalUnitName("pairwiseIdentifiers");
        branch.setDn(this.getBaseDnForPairwiseIdentifiers(userInum));
        this.ldapEntryManager.persist((Object)branch);
    }

    public boolean containsBranch(String userInum) {
        return this.ldapEntryManager.contains(this.getBaseDnForPairwiseIdentifiers(userInum), SimpleBranch.class);
    }

    public void prepareBranch(String userInum) {
        if (!this.ldapEntryManager.hasBranchesSupport(this.userService.getDnForUser(userInum))) {
            return;
        }
        if (!this.containsBranch(userInum)) {
            this.addBranch(userInum);
        }
    }

    public PairwiseIdentifier findPairWiseIdentifier(String userInum, String sectorIdentifier, String clientId, String openidSubValue) throws Exception {
        PairwiseIdType pairwiseIdType = PairwiseIdType.fromString((String)this.appConfiguration.getPairwiseIdType());
        if (PairwiseIdType.PERSISTENT == pairwiseIdType) {
            Filter filter;
            Filter sectorIdentifierFilter;
            this.prepareBranch(userInum);
            String baseDnForPairwiseIdentifiers = this.getBaseDnForPairwiseIdentifiers(userInum);
            if (BooleanUtils.isTrue((Boolean)this.appConfiguration.isShareSubjectIdBetweenClientsWithSameSectorId())) {
                sectorIdentifierFilter = Filter.createEqualityFilter((String)"jansSectorIdentifier", (Object)sectorIdentifier);
                Filter userInumFilter = Filter.createEqualityFilter((String)"jansUsrId", (Object)userInum);
                filter = Filter.createANDFilter((Filter[])new Filter[]{sectorIdentifierFilter, userInumFilter});
            } else {
                sectorIdentifierFilter = Filter.createEqualityFilter((String)"jansSectorIdentifier", (Object)sectorIdentifier);
                Filter clientIdFilter = Filter.createEqualityFilter((String)"jansClntId", (Object)clientId);
                Filter userInumFilter = Filter.createEqualityFilter((String)"jansUsrId", (Object)userInum);
                filter = Filter.createANDFilter((Filter[])new Filter[]{sectorIdentifierFilter, clientIdFilter, userInumFilter});
            }
            List entries = this.ldapEntryManager.findEntries(baseDnForPairwiseIdentifiers, PairwiseIdentifier.class, filter);
            if (entries != null && !entries.isEmpty()) {
                if (entries.size() > 1) {
                    this.log.error("Found more then one pairwise identifier by sector identifier: {}", (Object)sectorIdentifier);
                    for (PairwiseIdentifier pairwiseIdentifier : entries) {
                        this.log.error("PairwiseIdentifier: {}", (Object)pairwiseIdentifier);
                    }
                }
                return (PairwiseIdentifier)entries.get(0);
            }
        } else {
            String localAccountId;
            String key = this.appConfiguration.getPairwiseCalculationKey();
            String salt = this.appConfiguration.getPairwiseCalculationSalt();
            String string = localAccountId = BooleanUtils.isTrue((Boolean)this.appConfiguration.isShareSubjectIdBetweenClientsWithSameSectorId()) ? userInum : userInum + clientId;
            if (BooleanUtils.isTrue((Boolean)this.appConfiguration.getUseOpenidSubAttributeValueForPairwiseLocalAccountId())) {
                localAccountId = openidSubValue;
            }
            String calculatedSub = SubjectIdentifierGenerator.generatePairwiseSubjectIdentifier((String)sectorIdentifier, (String)localAccountId, (String)key, (String)salt, (AppConfiguration)this.appConfiguration);
            PairwiseIdentifier pairwiseIdentifier = new PairwiseIdentifier(sectorIdentifier, clientId, userInum);
            pairwiseIdentifier.setId(calculatedSub);
            return pairwiseIdentifier;
        }
        return null;
    }

    public void addPairwiseIdentifier(String userInum, PairwiseIdentifier pairwiseIdentifier) {
        this.prepareBranch(userInum);
        this.userService.addUserAttributeByUserInum(userInum, "jansPPID", (Object)pairwiseIdentifier.getId());
        this.ldapEntryManager.persist((Object)pairwiseIdentifier);
    }

    public String getDnForPairwiseIdentifier(String jsId, String userInum) {
        String baseDn = this.getBaseDnForPairwiseIdentifiers(userInum);
        if (StringHelper.isEmpty((String)jsId)) {
            return baseDn;
        }
        return String.format("jansId=%s,%s", jsId, baseDn);
    }

    public String getBaseDnForPairwiseIdentifiers(String userInum) {
        String userBaseDn = this.userService.getDnForUser(userInum);
        return String.format("ou=pairwiseIdentifiers,%s", userBaseDn);
    }
}

