/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.service;

import com.google.common.base.Preconditions;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.model.crypto.AbstractCryptoProvider;
import io.jans.as.model.crypto.signature.AlgorithmFamily;
import io.jans.as.model.crypto.signature.SignatureAlgorithm;
import io.jans.as.model.exception.CryptoProviderException;
import io.jans.as.model.jwk.Algorithm;
import io.jans.as.model.jwk.JSONWebKey;
import io.jans.as.model.jwk.JSONWebKeySet;
import io.jans.as.model.jwk.KeyOpsType;
import io.jans.as.model.jwk.Use;
import io.jans.as.server.model.config.ConfigurationFactory;
import io.jans.service.cdi.util.CdiUtil;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.json.JSONObject;

public class ServerCryptoProvider
extends AbstractCryptoProvider {
    private static final Logger LOG = Logger.getLogger(ServerCryptoProvider.class);
    private final ConfigurationFactory configurationFactory = (ConfigurationFactory)((Object)CdiUtil.bean(ConfigurationFactory.class));
    private final AbstractCryptoProvider cryptoProvider;

    public ServerCryptoProvider(AbstractCryptoProvider cryptoProvider) {
        this.cryptoProvider = cryptoProvider;
        Preconditions.checkNotNull((Object)((Object)this.configurationFactory));
        Preconditions.checkNotNull((Object)cryptoProvider);
    }

    public String getKeyId(JSONWebKeySet jsonWebKeySet, Algorithm algorithm, Use use, KeyOpsType keyOps) throws CryptoProviderException {
        try {
            String staticKid;
            if (algorithm == null || AlgorithmFamily.HMAC.equals((Object)algorithm.getFamily())) {
                return null;
            }
            AppConfiguration appConfiguration = this.configurationFactory.getAppConfiguration();
            if (BooleanUtils.isTrue((Boolean)appConfiguration.getKeySignWithSameKeyButDiffAlg())) {
                LOG.trace((Object)("Getting key by use: " + use));
                for (JSONWebKey key : jsonWebKeySet.getKeys()) {
                    if (use == null || use != key.getUse()) continue;
                    LOG.trace((Object)("Found " + key.getKid() + ", use: " + use));
                    return key.getKid();
                }
            }
            if (StringUtils.isNotBlank((CharSequence)(staticKid = appConfiguration.getStaticKid()))) {
                LOG.trace((Object)("Use staticKid: " + staticKid));
                return staticKid;
            }
            String kid = this.cryptoProvider.getKeyId(jsonWebKeySet, algorithm, use, keyOps);
            if (!this.cryptoProvider.getKeys().contains(kid) && this.configurationFactory.reloadConfFromLdap()) {
                return this.cryptoProvider.getKeyId(jsonWebKeySet, algorithm, use, keyOps);
            }
            return kid;
        }
        catch (CryptoProviderException e) {
            LOG.trace((Object)"Try to re-load configuration due to keystore exception (it can be rotated).");
            if (this.configurationFactory.reloadConfFromLdap()) {
                return this.cryptoProvider.getKeyId(jsonWebKeySet, algorithm, use, keyOps);
            }
            return null;
        }
    }

    public JSONObject generateKey(Algorithm algorithm, Long expirationTime, int keyLength) throws CryptoProviderException {
        return this.cryptoProvider.generateKey(algorithm, expirationTime, keyLength);
    }

    public JSONObject generateKey(Algorithm algorithm, Long expirationTime, int keyLength, KeyOpsType keyOpsType) throws CryptoProviderException {
        return this.cryptoProvider.generateKey(algorithm, expirationTime, keyLength, keyOpsType);
    }

    public JSONObject generateKey(Algorithm algorithm, Long expirationTime) throws CryptoProviderException {
        return this.generateKey(algorithm, expirationTime, 2048);
    }

    public String sign(String signingInput, String keyId, String sharedSecret, SignatureAlgorithm signatureAlgorithm) throws CryptoProviderException {
        if (this.configurationFactory.getAppConfiguration().getRejectJwtWithNoneAlg().booleanValue() && signatureAlgorithm == SignatureAlgorithm.NONE) {
            throw new UnsupportedOperationException("None algorithm is forbidden by `rejectJwtWithNoneAlg` configuration property.");
        }
        return this.cryptoProvider.sign(signingInput, keyId, sharedSecret, signatureAlgorithm);
    }

    public boolean verifySignature(String signingInput, String encodedSignature, String keyId, JSONObject jwks, String sharedSecret, SignatureAlgorithm signatureAlgorithm) throws CryptoProviderException {
        if (this.configurationFactory.getAppConfiguration().getRejectJwtWithNoneAlg().booleanValue() && signatureAlgorithm == SignatureAlgorithm.NONE) {
            LOG.trace((Object)"None algorithm is forbidden by `rejectJwtWithNoneAlg` configuration property.");
            return false;
        }
        return this.cryptoProvider.verifySignature(signingInput, encodedSignature, keyId, jwks, sharedSecret, signatureAlgorithm);
    }

    public boolean deleteKey(String keyId) throws CryptoProviderException {
        return this.cryptoProvider.deleteKey(keyId);
    }

    public boolean containsKey(String keyId) {
        return this.cryptoProvider.containsKey(keyId);
    }

    public PrivateKey getPrivateKey(String keyId) throws CryptoProviderException {
        AppConfiguration appConfiguration;
        PrivateKey privateKey = this.cryptoProvider.getPrivateKey(keyId);
        if (privateKey == null && StringUtils.isNotBlank((CharSequence)(appConfiguration = this.configurationFactory.getAppConfiguration()).getStaticDecryptionKid())) {
            privateKey = this.cryptoProvider.getPrivateKey(appConfiguration.getStaticDecryptionKid());
        }
        return privateKey;
    }

    public PublicKey getPublicKey(String keyId) throws CryptoProviderException {
        AppConfiguration appConfiguration;
        PublicKey publicKey = this.cryptoProvider.getPublicKey(keyId);
        if (publicKey == null && StringUtils.isNotBlank((CharSequence)(appConfiguration = this.configurationFactory.getAppConfiguration()).getStaticDecryptionKid())) {
            publicKey = this.cryptoProvider.getPublicKey(appConfiguration.getStaticDecryptionKid());
        }
        return publicKey;
    }
}

