/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.jans.as.common.model.registration.Client;
import io.jans.as.model.common.CreatorType;
import io.jans.as.model.common.ScopeType;
import io.jans.as.model.config.StaticConfiguration;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.model.util.Pair;
import io.jans.as.persistence.model.Scope;
import io.jans.as.server.service.ScopeService;
import jakarta.ejb.Stateless;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;

@Stateless
@Named
public class SpontaneousScopeService {
    private static final int DEFAULT_SPONTANEOUS_SCOPE_LIFETIME_IN_SECONDS = 86400;
    @Inject
    private Logger log;
    @Inject
    private StaticConfiguration staticConfiguration;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private ScopeService scopeService;

    public Scope createSpontaneousScopeIfNeeded(Set<String> regExps, String scopeId, String clientId) {
        Scope fromPersistence = this.scopeService.getScopeById(scopeId);
        if (fromPersistence != null) {
            return fromPersistence;
        }
        Pair<Boolean, String> isAllowed = this.isAllowedBySpontaneousScopes(regExps, scopeId);
        if (BooleanUtils.isFalse((Boolean)((Boolean)isAllowed.getFirst()))) {
            this.log.error("Forbidden by client. Check client configuration.");
            return null;
        }
        Scope regexpScope = this.scopeService.getScopeById((String)isAllowed.getSecond());
        Scope scope = new Scope();
        scope.setDefaultScope(Boolean.valueOf(false));
        scope.setDescription("Spontaneous scope: " + scopeId);
        scope.setDisplayName(scopeId);
        scope.setId(scopeId);
        scope.setInum(UUID.randomUUID().toString());
        scope.setScopeType(ScopeType.SPONTANEOUS);
        scope.setDeletable(Boolean.valueOf(true));
        scope.setExpirationDate(new Date(this.getLifetime()));
        scope.setDn("inum=" + scope.getInum() + "," + this.staticConfiguration.getBaseDn().getScopes());
        scope.setCreatorId(clientId);
        scope.setCreatorType(CreatorType.CLIENT);
        scope.getAttributes().setSpontaneousClientScopes((List)Lists.newArrayList((Object[])new String[]{(String)isAllowed.getSecond()}));
        scope.setUmaAuthorizationPolicies(regexpScope != null ? regexpScope.getUmaAuthorizationPolicies() : new ArrayList());
        this.scopeService.persist(scope);
        this.log.trace("Created spontaneous scope: {}, dn: {}", (Object)scope.getId(), (Object)scope.getDn());
        return scope;
    }

    public long getLifetime() {
        Calendar expiration = Calendar.getInstance();
        int lifetime = 86400;
        if (this.appConfiguration.getSpontaneousScopeLifetime() > 0) {
            lifetime = this.appConfiguration.getSpontaneousScopeLifetime();
        }
        expiration.add(13, lifetime);
        return expiration.getTimeInMillis();
    }

    public boolean isAllowedBySpontaneousScopes(Client client, String scopeRequested) {
        if (BooleanUtils.isFalse((Boolean)this.appConfiguration.getAllowSpontaneousScopes())) {
            return false;
        }
        if (BooleanUtils.isFalse((Boolean)client.getAttributes().getAllowSpontaneousScopes())) {
            return false;
        }
        return (Boolean)this.isAllowedBySpontaneousScopes(Sets.newHashSet((Iterable)client.getAttributes().getSpontaneousScopes()), scopeRequested).getFirst();
    }

    public boolean isAllowedBySpontaneousScopeRegExps(Set<String> regExps, String scopeRequested) {
        return (Boolean)this.isAllowedBySpontaneousScopes(regExps, scopeRequested).getFirst();
    }

    public Pair<Boolean, String> isAllowedBySpontaneousScopes(Set<String> regExps, String scopeRequested) {
        for (String spontaneousScope : regExps) {
            if (!this.isAllowedBySpontaneousScope(spontaneousScope, scopeRequested)) continue;
            return new Pair((Object)true, (Object)spontaneousScope);
        }
        return new Pair((Object)false, null);
    }

    public boolean isAllowedBySpontaneousScope(String spontaneousScope, String scopeRequested) {
        try {
            boolean result = spontaneousScope.equals(scopeRequested);
            if (!result) {
                result = Pattern.matches(spontaneousScope, scopeRequested);
            }
            if (result) {
                this.log.trace("Scope {} allowed by spontaneous scope: {}", (Object)scopeRequested, (Object)spontaneousScope);
            }
            return result;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }
}

