/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.service;

import io.jans.as.model.configuration.AppConfiguration;
import io.jans.util.StringHelper;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.faces.context.FacesContext;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.servlet.ServletContext;

@ApplicationScoped
@Named
public class WebConfigurationService {
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private ServletContext context;

    public String getCssLocation() {
        if (StringHelper.isEmpty((String)this.appConfiguration.getCssLocation())) {
            FacesContext ctx = FacesContext.getCurrentInstance();
            if (ctx == null) {
                return "";
            }
            String contextPath = ctx.getExternalContext().getRequestContextPath();
            return contextPath + "/stylesheet";
        }
        return this.appConfiguration.getCssLocation();
    }

    public String getJsLocation() {
        if (StringHelper.isEmpty((String)this.appConfiguration.getJsLocation())) {
            String contextPath = this.context.getContextPath();
            return contextPath + "/js";
        }
        return this.appConfiguration.getJsLocation();
    }

    public String getImgLocation() {
        if (StringHelper.isEmpty((String)this.appConfiguration.getImgLocation())) {
            String contextPath = this.context.getContextPath();
            return contextPath + "/img";
        }
        return this.appConfiguration.getImgLocation();
    }
}

