/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.service.external;

import io.jans.as.server.service.external.context.ExternalCibaEndUserNotificationContext;
import io.jans.model.custom.script.CustomScriptType;
import io.jans.model.custom.script.conf.CustomScriptConfiguration;
import io.jans.model.custom.script.type.ciba.EndUserNotificationType;
import io.jans.service.custom.script.ExternalScriptService;
import jakarta.ejb.DependsOn;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Named;

@ApplicationScoped
@DependsOn(value={"appInitializer"})
@Named
public class ExternalCibaEndUserNotificationService
extends ExternalScriptService {
    private static final long serialVersionUID = -8609727759114795446L;

    public ExternalCibaEndUserNotificationService() {
        super(CustomScriptType.CIBA_END_USER_NOTIFICATION);
    }

    public boolean executeExternalNotifyEndUser(ExternalCibaEndUserNotificationContext context) {
        if (this.customScriptConfigurations == null || this.customScriptConfigurations.isEmpty()) {
            this.log.trace("There is no any external interception scripts defined.");
            return false;
        }
        for (CustomScriptConfiguration script : this.customScriptConfigurations) {
            if (this.executeExternalNotifyEndUser(script, context)) continue;
            this.log.trace("Stopped running external interception scripts because script {} returns false.", (Object)script.getName());
            return false;
        }
        return true;
    }

    private boolean executeExternalNotifyEndUser(CustomScriptConfiguration customScriptConfiguration, ExternalCibaEndUserNotificationContext context) {
        try {
            this.log.trace("Executing external 'executeExternalNotifyEndUser' method, script name: {}, context: {}", (Object)customScriptConfiguration.getName(), (Object)context);
            EndUserNotificationType script = (EndUserNotificationType)customScriptConfiguration.getExternalType();
            boolean result = script.notifyEndUser((Object)context);
            this.log.trace("Finished external 'executeExternalNotifyEndUser' method, script name: {}, context: {}, result: {}", new Object[]{customScriptConfiguration.getName(), context, result});
            return result;
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            this.saveScriptError(customScriptConfiguration.getCustomScript(), ex);
            return false;
        }
    }
}

