/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.service.external;

import io.jans.model.custom.script.CustomScriptType;
import io.jans.model.custom.script.conf.CustomScriptConfiguration;
import io.jans.model.custom.script.type.cookie.CookieType;
import io.jans.service.custom.script.ExternalScriptService;
import jakarta.enterprise.context.ApplicationScoped;

@ApplicationScoped
public class ExternalCookieService
extends ExternalScriptService {
    public ExternalCookieService() {
        super(CustomScriptType.COOKIE);
    }

    public String modifyCookieHeader(String cookieName, String cookieHeader) {
        CustomScriptConfiguration script = this.getDefaultExternalCustomScript();
        if (script == null) {
            this.log.trace("No cookie script set.");
            return cookieHeader;
        }
        try {
            this.log.trace("Executing python 'modifyCookieHeader' method, script name: {}, cookieName: {}, cookieHeader: {}", new Object[]{script.getName(), cookieName, cookieHeader});
            CookieType cookieType = (CookieType)script.getExternalType();
            String headerFromScript = cookieType.modifyCookieHeader(cookieName, cookieHeader);
            this.log.trace("Finished 'modifyCookieHeader' method, script name: {}, cookieName: {}, cookieHeader: {}, headerFromScript: {}", new Object[]{script.getName(), cookieName, cookieHeader, headerFromScript});
            return headerFromScript;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            this.saveScriptError(script.getCustomScript(), e);
            return cookieHeader;
        }
    }
}

